/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.ListIdentitiesRequest;

public class ListIdentitiesRequestMarshaller
implements Marshaller<Request<ListIdentitiesRequest>, ListIdentitiesRequest> {
    public Request<ListIdentitiesRequest> marshall(ListIdentitiesRequest listIdentitiesRequest) {
        if (listIdentitiesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)listIdentitiesRequest, "SESClient");
        request.addParameter("Action", "ListIdentities");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (listIdentitiesRequest.identityTypeString() != null) {
            request.addParameter("IdentityType", StringUtils.fromString((String)listIdentitiesRequest.identityTypeString()));
        }
        if (listIdentitiesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listIdentitiesRequest.nextToken()));
        }
        if (listIdentitiesRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)listIdentitiesRequest.maxItems()));
        }
        return request;
    }
}

