/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.ListConfigurationSetsRequest;

public class ListConfigurationSetsRequestMarshaller
implements Marshaller<Request<ListConfigurationSetsRequest>, ListConfigurationSetsRequest> {
    public Request<ListConfigurationSetsRequest> marshall(ListConfigurationSetsRequest listConfigurationSetsRequest) {
        if (listConfigurationSetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)listConfigurationSetsRequest, "SESClient");
        request.addParameter("Action", "ListConfigurationSets");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (listConfigurationSetsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listConfigurationSetsRequest.nextToken()));
        }
        if (listConfigurationSetsRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)listConfigurationSetsRequest.maxItems()));
        }
        return request;
    }
}

