/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WorkmailAction
implements ToCopyableBuilder<Builder, WorkmailAction> {
    private final String topicArn;
    private final String organizationArn;

    private WorkmailAction(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.organizationArn = builder.organizationArn;
    }

    public String topicArn() {
        return this.topicArn;
    }

    public String organizationArn() {
        return this.organizationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkmailAction)) {
            return false;
        }
        WorkmailAction other = (WorkmailAction)obj;
        return Objects.equals(this.topicArn(), other.topicArn()) && Objects.equals(this.organizationArn(), other.organizationArn());
    }

    public String toString() {
        return ToString.builder((String)"WorkmailAction").add("TopicArn", (Object)this.topicArn()).add("OrganizationArn", (Object)this.organizationArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicArn": {
                return Optional.of(clazz.cast(this.topicArn()));
            }
            case "OrganizationArn": {
                return Optional.of(clazz.cast(this.organizationArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String topicArn;
        private String organizationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkmailAction model) {
            this.topicArn(model.topicArn);
            this.organizationArn(model.organizationArn);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getOrganizationArn() {
            return this.organizationArn;
        }

        @Override
        public final Builder organizationArn(String organizationArn) {
            this.organizationArn = organizationArn;
            return this;
        }

        public final void setOrganizationArn(String organizationArn) {
            this.organizationArn = organizationArn;
        }

        public WorkmailAction build() {
            return new WorkmailAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WorkmailAction> {
        public Builder topicArn(String var1);

        public Builder organizationArn(String var1);
    }
}

