/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ses.model.ConfigurationSet;
import software.amazon.awssdk.services.ses.model.EventDestination;
import software.amazon.awssdk.services.ses.model.EventDestinationsCopier;
import software.amazon.awssdk.services.ses.model.ReputationOptions;
import software.amazon.awssdk.services.ses.model.SESResponse;
import software.amazon.awssdk.services.ses.model.TrackingOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeConfigurationSetResponse
extends SESResponse
implements ToCopyableBuilder<Builder, DescribeConfigurationSetResponse> {
    private final ConfigurationSet configurationSet;
    private final List<EventDestination> eventDestinations;
    private final TrackingOptions trackingOptions;
    private final ReputationOptions reputationOptions;

    private DescribeConfigurationSetResponse(BuilderImpl builder) {
        super(builder);
        this.configurationSet = builder.configurationSet;
        this.eventDestinations = builder.eventDestinations;
        this.trackingOptions = builder.trackingOptions;
        this.reputationOptions = builder.reputationOptions;
    }

    public ConfigurationSet configurationSet() {
        return this.configurationSet;
    }

    public List<EventDestination> eventDestinations() {
        return this.eventDestinations;
    }

    public TrackingOptions trackingOptions() {
        return this.trackingOptions;
    }

    public ReputationOptions reputationOptions() {
        return this.reputationOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDestinations());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.reputationOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationSetResponse)) {
            return false;
        }
        DescribeConfigurationSetResponse other = (DescribeConfigurationSetResponse)((Object)obj);
        return Objects.equals(this.configurationSet(), other.configurationSet()) && Objects.equals(this.eventDestinations(), other.eventDestinations()) && Objects.equals(this.trackingOptions(), other.trackingOptions()) && Objects.equals(this.reputationOptions(), other.reputationOptions());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConfigurationSetResponse").add("ConfigurationSet", (Object)this.configurationSet()).add("EventDestinations", this.eventDestinations()).add("TrackingOptions", (Object)this.trackingOptions()).add("ReputationOptions", (Object)this.reputationOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSet": {
                return Optional.of(clazz.cast(this.configurationSet()));
            }
            case "EventDestinations": {
                return Optional.of(clazz.cast(this.eventDestinations()));
            }
            case "TrackingOptions": {
                return Optional.of(clazz.cast(this.trackingOptions()));
            }
            case "ReputationOptions": {
                return Optional.of(clazz.cast(this.reputationOptions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESResponse.BuilderImpl
    implements Builder {
        private ConfigurationSet configurationSet;
        private List<EventDestination> eventDestinations;
        private TrackingOptions trackingOptions;
        private ReputationOptions reputationOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationSetResponse model) {
            this.configurationSet(model.configurationSet);
            this.eventDestinations(model.eventDestinations);
            this.trackingOptions(model.trackingOptions);
            this.reputationOptions(model.reputationOptions);
        }

        public final ConfigurationSet.Builder getConfigurationSet() {
            return this.configurationSet != null ? this.configurationSet.toBuilder() : null;
        }

        @Override
        public final Builder configurationSet(ConfigurationSet configurationSet) {
            this.configurationSet = configurationSet;
            return this;
        }

        public final void setConfigurationSet(ConfigurationSet.BuilderImpl configurationSet) {
            this.configurationSet = configurationSet != null ? configurationSet.build() : null;
        }

        public final Collection<EventDestination.Builder> getEventDestinations() {
            return this.eventDestinations != null ? (Collection)this.eventDestinations.stream().map(EventDestination::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventDestinations(Collection<EventDestination> eventDestinations) {
            this.eventDestinations = EventDestinationsCopier.copy(eventDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventDestinations(EventDestination ... eventDestinations) {
            this.eventDestinations(Arrays.asList(eventDestinations));
            return this;
        }

        public final void setEventDestinations(Collection<EventDestination.BuilderImpl> eventDestinations) {
            this.eventDestinations = EventDestinationsCopier.copyFromBuilder(eventDestinations);
        }

        public final TrackingOptions.Builder getTrackingOptions() {
            return this.trackingOptions != null ? this.trackingOptions.toBuilder() : null;
        }

        @Override
        public final Builder trackingOptions(TrackingOptions trackingOptions) {
            this.trackingOptions = trackingOptions;
            return this;
        }

        public final void setTrackingOptions(TrackingOptions.BuilderImpl trackingOptions) {
            this.trackingOptions = trackingOptions != null ? trackingOptions.build() : null;
        }

        public final ReputationOptions.Builder getReputationOptions() {
            return this.reputationOptions != null ? this.reputationOptions.toBuilder() : null;
        }

        @Override
        public final Builder reputationOptions(ReputationOptions reputationOptions) {
            this.reputationOptions = reputationOptions;
            return this;
        }

        public final void setReputationOptions(ReputationOptions.BuilderImpl reputationOptions) {
            this.reputationOptions = reputationOptions != null ? reputationOptions.build() : null;
        }

        @Override
        public DescribeConfigurationSetResponse build() {
            return new DescribeConfigurationSetResponse(this);
        }
    }

    public static interface Builder
    extends SESResponse.Builder,
    CopyableBuilder<Builder, DescribeConfigurationSetResponse> {
        public Builder configurationSet(ConfigurationSet var1);

        default public Builder configurationSet(Consumer<ConfigurationSet.Builder> configurationSet) {
            return this.configurationSet((ConfigurationSet)((ConfigurationSet.Builder)ConfigurationSet.builder().apply(configurationSet)).build());
        }

        public Builder eventDestinations(Collection<EventDestination> var1);

        public Builder eventDestinations(EventDestination ... var1);

        public Builder trackingOptions(TrackingOptions var1);

        default public Builder trackingOptions(Consumer<TrackingOptions.Builder> trackingOptions) {
            return this.trackingOptions((TrackingOptions)((TrackingOptions.Builder)TrackingOptions.builder().apply(trackingOptions)).build());
        }

        public Builder reputationOptions(ReputationOptions var1);

        default public Builder reputationOptions(Consumer<ReputationOptions.Builder> reputationOptions) {
            return this.reputationOptions((ReputationOptions)((ReputationOptions.Builder)ReputationOptions.builder().apply(reputationOptions)).build());
        }
    }
}

