/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BounceAction
implements ToCopyableBuilder<Builder, BounceAction> {
    private final String topicArn;
    private final String smtpReplyCode;
    private final String statusCode;
    private final String message;
    private final String sender;

    private BounceAction(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.smtpReplyCode = builder.smtpReplyCode;
        this.statusCode = builder.statusCode;
        this.message = builder.message;
        this.sender = builder.sender;
    }

    public String topicArn() {
        return this.topicArn;
    }

    public String smtpReplyCode() {
        return this.smtpReplyCode;
    }

    public String statusCode() {
        return this.statusCode;
    }

    public String message() {
        return this.message;
    }

    public String sender() {
        return this.sender;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.smtpReplyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.sender());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BounceAction)) {
            return false;
        }
        BounceAction other = (BounceAction)obj;
        return Objects.equals(this.topicArn(), other.topicArn()) && Objects.equals(this.smtpReplyCode(), other.smtpReplyCode()) && Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.sender(), other.sender());
    }

    public String toString() {
        return ToString.builder((String)"BounceAction").add("TopicArn", (Object)this.topicArn()).add("SmtpReplyCode", (Object)this.smtpReplyCode()).add("StatusCode", (Object)this.statusCode()).add("Message", (Object)this.message()).add("Sender", (Object)this.sender()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicArn": {
                return Optional.of(clazz.cast(this.topicArn()));
            }
            case "SmtpReplyCode": {
                return Optional.of(clazz.cast(this.smtpReplyCode()));
            }
            case "StatusCode": {
                return Optional.of(clazz.cast(this.statusCode()));
            }
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
            case "Sender": {
                return Optional.of(clazz.cast(this.sender()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String topicArn;
        private String smtpReplyCode;
        private String statusCode;
        private String message;
        private String sender;

        private BuilderImpl() {
        }

        private BuilderImpl(BounceAction model) {
            this.topicArn(model.topicArn);
            this.smtpReplyCode(model.smtpReplyCode);
            this.statusCode(model.statusCode);
            this.message(model.message);
            this.sender(model.sender);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getSmtpReplyCode() {
            return this.smtpReplyCode;
        }

        @Override
        public final Builder smtpReplyCode(String smtpReplyCode) {
            this.smtpReplyCode = smtpReplyCode;
            return this;
        }

        public final void setSmtpReplyCode(String smtpReplyCode) {
            this.smtpReplyCode = smtpReplyCode;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getSender() {
            return this.sender;
        }

        @Override
        public final Builder sender(String sender) {
            this.sender = sender;
            return this;
        }

        public final void setSender(String sender) {
            this.sender = sender;
        }

        public BounceAction build() {
            return new BounceAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BounceAction> {
        public Builder topicArn(String var1);

        public Builder smtpReplyCode(String var1);

        public Builder statusCode(String var1);

        public Builder message(String var1);

        public Builder sender(String var1);
    }
}

