/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.SendDataPoint;

public class SendDataPointUnmarshaller
implements Unmarshaller<SendDataPoint, StaxUnmarshallerContext> {
    private static final SendDataPointUnmarshaller INSTANCE = new SendDataPointUnmarshaller();

    public SendDataPoint unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        SendDataPoint.Builder sendDataPoint = SendDataPoint.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Timestamp", targetDepth)) {
                    sendDataPoint.timestamp(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DeliveryAttempts", targetDepth)) {
                    sendDataPoint.deliveryAttempts(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Bounces", targetDepth)) {
                    sendDataPoint.bounces(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Complaints", targetDepth)) {
                    sendDataPoint.complaints(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Rejects", targetDepth)) continue;
                sendDataPoint.rejects(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (SendDataPoint)sendDataPoint.build();
    }

    public static SendDataPointUnmarshaller getInstance() {
        return INSTANCE;
    }
}

