/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ses.model.ReceiptAction;
import software.amazon.awssdk.services.ses.model.ReceiptActionsListCopier;
import software.amazon.awssdk.services.ses.model.RecipientsListCopier;
import software.amazon.awssdk.services.ses.model.TlsPolicy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReceiptRule
implements ToCopyableBuilder<Builder, ReceiptRule> {
    private final String name;
    private final Boolean enabled;
    private final String tlsPolicy;
    private final List<String> recipients;
    private final List<ReceiptAction> actions;
    private final Boolean scanEnabled;

    private ReceiptRule(BuilderImpl builder) {
        this.name = builder.name;
        this.enabled = builder.enabled;
        this.tlsPolicy = builder.tlsPolicy;
        this.recipients = builder.recipients;
        this.actions = builder.actions;
        this.scanEnabled = builder.scanEnabled;
    }

    public String name() {
        return this.name;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public TlsPolicy tlsPolicy() {
        return TlsPolicy.fromValue(this.tlsPolicy);
    }

    public String tlsPolicyString() {
        return this.tlsPolicy;
    }

    public List<String> recipients() {
        return this.recipients;
    }

    public List<ReceiptAction> actions() {
        return this.actions;
    }

    public Boolean scanEnabled() {
        return this.scanEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsPolicyString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipients());
        hashCode = 31 * hashCode + Objects.hashCode(this.actions());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanEnabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiptRule)) {
            return false;
        }
        ReceiptRule other = (ReceiptRule)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.tlsPolicyString(), other.tlsPolicyString()) && Objects.equals(this.recipients(), other.recipients()) && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.scanEnabled(), other.scanEnabled());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.tlsPolicyString() != null) {
            sb.append("TlsPolicy: ").append(this.tlsPolicyString()).append(",");
        }
        if (this.recipients() != null) {
            sb.append("Recipients: ").append(this.recipients()).append(",");
        }
        if (this.actions() != null) {
            sb.append("Actions: ").append(this.actions()).append(",");
        }
        if (this.scanEnabled() != null) {
            sb.append("ScanEnabled: ").append(this.scanEnabled()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
            case "TlsPolicy": {
                return Optional.of(clazz.cast(this.tlsPolicyString()));
            }
            case "Recipients": {
                return Optional.of(clazz.cast(this.recipients()));
            }
            case "Actions": {
                return Optional.of(clazz.cast(this.actions()));
            }
            case "ScanEnabled": {
                return Optional.of(clazz.cast(this.scanEnabled()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Boolean enabled;
        private String tlsPolicy;
        private List<String> recipients;
        private List<ReceiptAction> actions;
        private Boolean scanEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiptRule model) {
            this.name(model.name);
            this.enabled(model.enabled);
            this.tlsPolicy(model.tlsPolicy);
            this.recipients(model.recipients);
            this.actions(model.actions);
            this.scanEnabled(model.scanEnabled);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getTlsPolicy() {
            return this.tlsPolicy;
        }

        @Override
        public final Builder tlsPolicy(String tlsPolicy) {
            this.tlsPolicy = tlsPolicy;
            return this;
        }

        @Override
        public final Builder tlsPolicy(TlsPolicy tlsPolicy) {
            this.tlsPolicy(tlsPolicy.toString());
            return this;
        }

        public final void setTlsPolicy(String tlsPolicy) {
            this.tlsPolicy = tlsPolicy;
        }

        public final Collection<String> getRecipients() {
            return this.recipients;
        }

        @Override
        public final Builder recipients(Collection<String> recipients) {
            this.recipients = RecipientsListCopier.copy(recipients);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recipients(String ... recipients) {
            this.recipients(Arrays.asList(recipients));
            return this;
        }

        public final void setRecipients(Collection<String> recipients) {
            this.recipients = RecipientsListCopier.copy(recipients);
        }

        public final Collection<ReceiptAction.Builder> getActions() {
            return this.actions != null ? (Collection)this.actions.stream().map(ReceiptAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<ReceiptAction> actions) {
            this.actions = ReceiptActionsListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(ReceiptAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public final void setActions(Collection<ReceiptAction.BuilderImpl> actions) {
            this.actions = ReceiptActionsListCopier.copyFromBuilder(actions);
        }

        public final Boolean getScanEnabled() {
            return this.scanEnabled;
        }

        @Override
        public final Builder scanEnabled(Boolean scanEnabled) {
            this.scanEnabled = scanEnabled;
            return this;
        }

        public final void setScanEnabled(Boolean scanEnabled) {
            this.scanEnabled = scanEnabled;
        }

        public ReceiptRule build() {
            return new ReceiptRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReceiptRule> {
        public Builder name(String var1);

        public Builder enabled(Boolean var1);

        public Builder tlsPolicy(String var1);

        public Builder tlsPolicy(TlsPolicy var1);

        public Builder recipients(Collection<String> var1);

        public Builder recipients(String ... var1);

        public Builder actions(Collection<ReceiptAction> var1);

        public Builder actions(ReceiptAction ... var1);

        public Builder scanEnabled(Boolean var1);
    }
}

