/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ses.model.BulkEmailStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BulkEmailDestinationStatus
implements ToCopyableBuilder<Builder, BulkEmailDestinationStatus> {
    private final String status;
    private final String error;
    private final String messageId;

    private BulkEmailDestinationStatus(BuilderImpl builder) {
        this.status = builder.status;
        this.error = builder.error;
        this.messageId = builder.messageId;
    }

    public BulkEmailStatus status() {
        return BulkEmailStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public String error() {
        return this.error;
    }

    public String messageId() {
        return this.messageId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BulkEmailDestinationStatus)) {
            return false;
        }
        BulkEmailDestinationStatus other = (BulkEmailDestinationStatus)obj;
        return Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.messageId(), other.messageId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (this.error() != null) {
            sb.append("Error: ").append(this.error()).append(",");
        }
        if (this.messageId() != null) {
            sb.append("MessageId: ").append(this.messageId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "Error": {
                return Optional.of(clazz.cast(this.error()));
            }
            case "MessageId": {
                return Optional.of(clazz.cast(this.messageId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String error;
        private String messageId;

        private BuilderImpl() {
        }

        private BuilderImpl(BulkEmailDestinationStatus model) {
            this.status(model.status);
            this.error(model.error);
            this.messageId(model.messageId);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BulkEmailStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getError() {
            return this.error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final void setError(String error) {
            this.error = error;
        }

        public final String getMessageId() {
            return this.messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public BulkEmailDestinationStatus build() {
            return new BulkEmailDestinationStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BulkEmailDestinationStatus> {
        public Builder status(String var1);

        public Builder status(BulkEmailStatus var1);

        public Builder error(String var1);

        public Builder messageId(String var1);
    }
}

