/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.DeleteTemplateRequest;

public class DeleteTemplateRequestMarshaller
implements Marshaller<Request<DeleteTemplateRequest>, DeleteTemplateRequest> {
    public Request<DeleteTemplateRequest> marshall(DeleteTemplateRequest deleteTemplateRequest) {
        if (deleteTemplateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteTemplateRequest, "SESClient");
        request.addParameter("Action", "DeleteTemplate");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteTemplateRequest.templateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString((String)deleteTemplateRequest.templateName()));
        }
        return request;
    }
}

