/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.AddHeaderAction;
import software.amazon.awssdk.services.ses.model.BounceAction;
import software.amazon.awssdk.services.ses.model.CreateReceiptRuleRequest;
import software.amazon.awssdk.services.ses.model.LambdaAction;
import software.amazon.awssdk.services.ses.model.ReceiptAction;
import software.amazon.awssdk.services.ses.model.ReceiptRule;
import software.amazon.awssdk.services.ses.model.S3Action;
import software.amazon.awssdk.services.ses.model.SNSAction;
import software.amazon.awssdk.services.ses.model.StopAction;
import software.amazon.awssdk.services.ses.model.WorkmailAction;

public class CreateReceiptRuleRequestMarshaller
implements Marshaller<Request<CreateReceiptRuleRequest>, CreateReceiptRuleRequest> {
    public Request<CreateReceiptRuleRequest> marshall(CreateReceiptRuleRequest createReceiptRuleRequest) {
        ReceiptRule rule;
        if (createReceiptRuleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createReceiptRuleRequest, "SESClient");
        request.addParameter("Action", "CreateReceiptRule");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createReceiptRuleRequest.ruleSetName() != null) {
            request.addParameter("RuleSetName", StringUtils.fromString((String)createReceiptRuleRequest.ruleSetName()));
        }
        if (createReceiptRuleRequest.after() != null) {
            request.addParameter("After", StringUtils.fromString((String)createReceiptRuleRequest.after()));
        }
        if ((rule = createReceiptRuleRequest.rule()) != null) {
            List<ReceiptAction> actionsList;
            List<String> recipientsList;
            if (rule.name() != null) {
                request.addParameter("Rule.Name", StringUtils.fromString((String)rule.name()));
            }
            if (rule.enabled() != null) {
                request.addParameter("Rule.Enabled", StringUtils.fromBoolean((Boolean)rule.enabled()));
            }
            if (rule.tlsPolicyString() != null) {
                request.addParameter("Rule.TlsPolicy", StringUtils.fromString((String)rule.tlsPolicyString()));
            }
            if ((recipientsList = rule.recipients()) != null) {
                if (!recipientsList.isEmpty()) {
                    int recipientsListIndex = 1;
                    for (String recipientsListValue : recipientsList) {
                        if (recipientsListValue != null) {
                            request.addParameter("Rule.Recipients.member." + recipientsListIndex, StringUtils.fromString((String)recipientsListValue));
                        }
                        ++recipientsListIndex;
                    }
                } else {
                    request.addParameter("Rule.Recipients", "");
                }
            }
            if ((actionsList = rule.actions()) != null) {
                if (!actionsList.isEmpty()) {
                    int actionsListIndex = 1;
                    for (ReceiptAction actionsListValue : actionsList) {
                        SNSAction snsAction;
                        AddHeaderAction addHeaderAction;
                        StopAction stopAction;
                        LambdaAction lambdaAction;
                        WorkmailAction workmailAction;
                        BounceAction bounceAction;
                        S3Action s3Action = actionsListValue.s3Action();
                        if (s3Action != null) {
                            if (s3Action.topicArn() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.TopicArn", StringUtils.fromString((String)s3Action.topicArn()));
                            }
                            if (s3Action.bucketName() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.BucketName", StringUtils.fromString((String)s3Action.bucketName()));
                            }
                            if (s3Action.objectKeyPrefix() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.ObjectKeyPrefix", StringUtils.fromString((String)s3Action.objectKeyPrefix()));
                            }
                            if (s3Action.kmsKeyArn() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.KmsKeyArn", StringUtils.fromString((String)s3Action.kmsKeyArn()));
                            }
                        }
                        if ((bounceAction = actionsListValue.bounceAction()) != null) {
                            if (bounceAction.topicArn() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.TopicArn", StringUtils.fromString((String)bounceAction.topicArn()));
                            }
                            if (bounceAction.smtpReplyCode() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.SmtpReplyCode", StringUtils.fromString((String)bounceAction.smtpReplyCode()));
                            }
                            if (bounceAction.statusCode() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.StatusCode", StringUtils.fromString((String)bounceAction.statusCode()));
                            }
                            if (bounceAction.message() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.Message", StringUtils.fromString((String)bounceAction.message()));
                            }
                            if (bounceAction.sender() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.Sender", StringUtils.fromString((String)bounceAction.sender()));
                            }
                        }
                        if ((workmailAction = actionsListValue.workmailAction()) != null) {
                            if (workmailAction.topicArn() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".WorkmailAction.TopicArn", StringUtils.fromString((String)workmailAction.topicArn()));
                            }
                            if (workmailAction.organizationArn() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".WorkmailAction.OrganizationArn", StringUtils.fromString((String)workmailAction.organizationArn()));
                            }
                        }
                        if ((lambdaAction = actionsListValue.lambdaAction()) != null) {
                            if (lambdaAction.topicArn() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".LambdaAction.TopicArn", StringUtils.fromString((String)lambdaAction.topicArn()));
                            }
                            if (lambdaAction.functionArn() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".LambdaAction.FunctionArn", StringUtils.fromString((String)lambdaAction.functionArn()));
                            }
                            if (lambdaAction.invocationTypeString() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".LambdaAction.InvocationType", StringUtils.fromString((String)lambdaAction.invocationTypeString()));
                            }
                        }
                        if ((stopAction = actionsListValue.stopAction()) != null) {
                            if (stopAction.scopeString() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".StopAction.Scope", StringUtils.fromString((String)stopAction.scopeString()));
                            }
                            if (stopAction.topicArn() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".StopAction.TopicArn", StringUtils.fromString((String)stopAction.topicArn()));
                            }
                        }
                        if ((addHeaderAction = actionsListValue.addHeaderAction()) != null) {
                            if (addHeaderAction.headerName() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".AddHeaderAction.HeaderName", StringUtils.fromString((String)addHeaderAction.headerName()));
                            }
                            if (addHeaderAction.headerValue() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".AddHeaderAction.HeaderValue", StringUtils.fromString((String)addHeaderAction.headerValue()));
                            }
                        }
                        if ((snsAction = actionsListValue.snsAction()) != null) {
                            if (snsAction.topicArn() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".SNSAction.TopicArn", StringUtils.fromString((String)snsAction.topicArn()));
                            }
                            if (snsAction.encodingString() != null) {
                                request.addParameter("Rule.Actions.member." + actionsListIndex + ".SNSAction.Encoding", StringUtils.fromString((String)snsAction.encodingString()));
                            }
                        }
                        ++actionsListIndex;
                    }
                } else {
                    request.addParameter("Rule.Actions", "");
                }
            }
            if (rule.scanEnabled() != null) {
                request.addParameter("Rule.ScanEnabled", StringUtils.fromBoolean((Boolean)rule.scanEnabled()));
            }
        }
        return request;
    }
}

