/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.BouncedRecipientInfo;
import software.amazon.awssdk.services.ses.transform.RecipientDsnFieldsUnmarshaller;

public class BouncedRecipientInfoUnmarshaller
implements Unmarshaller<BouncedRecipientInfo, StaxUnmarshallerContext> {
    private static final BouncedRecipientInfoUnmarshaller INSTANCE = new BouncedRecipientInfoUnmarshaller();

    public BouncedRecipientInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        BouncedRecipientInfo.Builder bouncedRecipientInfo = BouncedRecipientInfo.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Recipient", targetDepth)) {
                    bouncedRecipientInfo.recipient(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RecipientArn", targetDepth)) {
                    bouncedRecipientInfo.recipientArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BounceType", targetDepth)) {
                    bouncedRecipientInfo.bounceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("RecipientDsnFields", targetDepth)) continue;
                bouncedRecipientInfo.recipientDsnFields(RecipientDsnFieldsUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (BouncedRecipientInfo)bouncedRecipientInfo.build();
    }

    public static BouncedRecipientInfoUnmarshaller getInstance() {
        return INSTANCE;
    }
}

