/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ses.model.DkimAttributesCopier;
import software.amazon.awssdk.services.ses.model.IdentityDkimAttributes;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetIdentityDkimAttributesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetIdentityDkimAttributesResponse> {
    private final Map<String, IdentityDkimAttributes> dkimAttributes;

    private GetIdentityDkimAttributesResponse(BuilderImpl builder) {
        this.dkimAttributes = builder.dkimAttributes;
    }

    public Map<String, IdentityDkimAttributes> dkimAttributes() {
        return this.dkimAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dkimAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityDkimAttributesResponse)) {
            return false;
        }
        GetIdentityDkimAttributesResponse other = (GetIdentityDkimAttributesResponse)((Object)obj);
        return Objects.equals(this.dkimAttributes(), other.dkimAttributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dkimAttributes() != null) {
            sb.append("DkimAttributes: ").append(this.dkimAttributes()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DkimAttributes": {
                return Optional.of(clazz.cast(this.dkimAttributes()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, IdentityDkimAttributes> dkimAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityDkimAttributesResponse model) {
            this.dkimAttributes(model.dkimAttributes);
        }

        public final Map<String, IdentityDkimAttributes.Builder> getDkimAttributes() {
            return this.dkimAttributes != null ? CollectionUtils.mapValues(this.dkimAttributes, IdentityDkimAttributes::toBuilder) : null;
        }

        @Override
        public final Builder dkimAttributes(Map<String, IdentityDkimAttributes> dkimAttributes) {
            this.dkimAttributes = DkimAttributesCopier.copy(dkimAttributes);
            return this;
        }

        public final void setDkimAttributes(Map<String, IdentityDkimAttributes.BuilderImpl> dkimAttributes) {
            this.dkimAttributes = DkimAttributesCopier.copyFromBuilder(dkimAttributes);
        }

        public GetIdentityDkimAttributesResponse build() {
            return new GetIdentityDkimAttributesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetIdentityDkimAttributesResponse> {
        public Builder dkimAttributes(Map<String, IdentityDkimAttributes> var1);
    }
}

