/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.CloudWatchDestination;
import software.amazon.awssdk.services.ses.model.CloudWatchDimensionConfiguration;
import software.amazon.awssdk.services.ses.model.EventDestination;
import software.amazon.awssdk.services.ses.model.KinesisFirehoseDestination;
import software.amazon.awssdk.services.ses.model.UpdateConfigurationSetEventDestinationRequest;

public class UpdateConfigurationSetEventDestinationRequestMarshaller
implements Marshaller<Request<UpdateConfigurationSetEventDestinationRequest>, UpdateConfigurationSetEventDestinationRequest> {
    public Request<UpdateConfigurationSetEventDestinationRequest> marshall(UpdateConfigurationSetEventDestinationRequest updateConfigurationSetEventDestinationRequest) {
        EventDestination eventDestination;
        if (updateConfigurationSetEventDestinationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateConfigurationSetEventDestinationRequest, "SESClient");
        request.addParameter("Action", "UpdateConfigurationSetEventDestination");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateConfigurationSetEventDestinationRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString((String)updateConfigurationSetEventDestinationRequest.configurationSetName()));
        }
        if ((eventDestination = updateConfigurationSetEventDestinationRequest.eventDestination()) != null) {
            List<CloudWatchDimensionConfiguration> dimensionConfigurationsList;
            CloudWatchDestination cloudWatchDestination;
            KinesisFirehoseDestination kinesisFirehoseDestination;
            List<String> matchingEventTypesList;
            if (eventDestination.name() != null) {
                request.addParameter("EventDestination.Name", StringUtils.fromString((String)eventDestination.name()));
            }
            if (eventDestination.enabled() != null) {
                request.addParameter("EventDestination.Enabled", StringUtils.fromBoolean((Boolean)eventDestination.enabled()));
            }
            if ((matchingEventTypesList = eventDestination.matchingEventTypesStrings()) != null) {
                if (!matchingEventTypesList.isEmpty()) {
                    int matchingEventTypesListIndex = 1;
                    for (String matchingEventTypesListValue : matchingEventTypesList) {
                        if (matchingEventTypesListValue != null) {
                            request.addParameter("EventDestination.MatchingEventTypes.member." + matchingEventTypesListIndex, StringUtils.fromString((String)matchingEventTypesListValue));
                        }
                        ++matchingEventTypesListIndex;
                    }
                } else {
                    request.addParameter("EventDestination.MatchingEventTypes", "");
                }
            }
            if ((kinesisFirehoseDestination = eventDestination.kinesisFirehoseDestination()) != null) {
                if (kinesisFirehoseDestination.iamRoleARN() != null) {
                    request.addParameter("EventDestination.KinesisFirehoseDestination.IAMRoleARN", StringUtils.fromString((String)kinesisFirehoseDestination.iamRoleARN()));
                }
                if (kinesisFirehoseDestination.deliveryStreamARN() != null) {
                    request.addParameter("EventDestination.KinesisFirehoseDestination.DeliveryStreamARN", StringUtils.fromString((String)kinesisFirehoseDestination.deliveryStreamARN()));
                }
            }
            if ((cloudWatchDestination = eventDestination.cloudWatchDestination()) != null && (dimensionConfigurationsList = cloudWatchDestination.dimensionConfigurations()) != null) {
                if (!dimensionConfigurationsList.isEmpty()) {
                    int dimensionConfigurationsListIndex = 1;
                    for (CloudWatchDimensionConfiguration dimensionConfigurationsListValue : dimensionConfigurationsList) {
                        if (dimensionConfigurationsListValue.dimensionName() != null) {
                            request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member." + dimensionConfigurationsListIndex + ".DimensionName", StringUtils.fromString((String)dimensionConfigurationsListValue.dimensionName()));
                        }
                        if (dimensionConfigurationsListValue.dimensionValueSourceString() != null) {
                            request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member." + dimensionConfigurationsListIndex + ".DimensionValueSource", StringUtils.fromString((String)dimensionConfigurationsListValue.dimensionValueSourceString()));
                        }
                        if (dimensionConfigurationsListValue.defaultDimensionValue() != null) {
                            request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member." + dimensionConfigurationsListIndex + ".DefaultDimensionValue", StringUtils.fromString((String)dimensionConfigurationsListValue.defaultDimensionValue()));
                        }
                        ++dimensionConfigurationsListIndex;
                    }
                } else {
                    request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations", "");
                }
            }
        }
        return request;
    }
}

