/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ses.model.DsnAction;
import software.amazon.awssdk.services.ses.model.ExtensionField;
import software.amazon.awssdk.services.ses.model.ExtensionFieldListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RecipientDsnFields
implements ToCopyableBuilder<Builder, RecipientDsnFields> {
    private final String finalRecipient;
    private final String action;
    private final String remoteMta;
    private final String status;
    private final String diagnosticCode;
    private final Instant lastAttemptDate;
    private final List<ExtensionField> extensionFields;

    private RecipientDsnFields(BuilderImpl builder) {
        this.finalRecipient = builder.finalRecipient;
        this.action = builder.action;
        this.remoteMta = builder.remoteMta;
        this.status = builder.status;
        this.diagnosticCode = builder.diagnosticCode;
        this.lastAttemptDate = builder.lastAttemptDate;
        this.extensionFields = builder.extensionFields;
    }

    public String finalRecipient() {
        return this.finalRecipient;
    }

    public DsnAction action() {
        return DsnAction.fromValue(this.action);
    }

    public String actionString() {
        return this.action;
    }

    public String remoteMta() {
        return this.remoteMta;
    }

    public String status() {
        return this.status;
    }

    public String diagnosticCode() {
        return this.diagnosticCode;
    }

    public Instant lastAttemptDate() {
        return this.lastAttemptDate;
    }

    public List<ExtensionField> extensionFields() {
        return this.extensionFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.finalRecipient() == null ? 0 : this.finalRecipient().hashCode());
        hashCode = 31 * hashCode + (this.actionString() == null ? 0 : this.actionString().hashCode());
        hashCode = 31 * hashCode + (this.remoteMta() == null ? 0 : this.remoteMta().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.diagnosticCode() == null ? 0 : this.diagnosticCode().hashCode());
        hashCode = 31 * hashCode + (this.lastAttemptDate() == null ? 0 : this.lastAttemptDate().hashCode());
        hashCode = 31 * hashCode + (this.extensionFields() == null ? 0 : this.extensionFields().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecipientDsnFields)) {
            return false;
        }
        RecipientDsnFields other = (RecipientDsnFields)obj;
        if (other.finalRecipient() == null ^ this.finalRecipient() == null) {
            return false;
        }
        if (other.finalRecipient() != null && !other.finalRecipient().equals(this.finalRecipient())) {
            return false;
        }
        if (other.actionString() == null ^ this.actionString() == null) {
            return false;
        }
        if (other.actionString() != null && !other.actionString().equals(this.actionString())) {
            return false;
        }
        if (other.remoteMta() == null ^ this.remoteMta() == null) {
            return false;
        }
        if (other.remoteMta() != null && !other.remoteMta().equals(this.remoteMta())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.diagnosticCode() == null ^ this.diagnosticCode() == null) {
            return false;
        }
        if (other.diagnosticCode() != null && !other.diagnosticCode().equals(this.diagnosticCode())) {
            return false;
        }
        if (other.lastAttemptDate() == null ^ this.lastAttemptDate() == null) {
            return false;
        }
        if (other.lastAttemptDate() != null && !other.lastAttemptDate().equals(this.lastAttemptDate())) {
            return false;
        }
        if (other.extensionFields() == null ^ this.extensionFields() == null) {
            return false;
        }
        return other.extensionFields() == null || other.extensionFields().equals(this.extensionFields());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.finalRecipient() != null) {
            sb.append("FinalRecipient: ").append(this.finalRecipient()).append(",");
        }
        if (this.actionString() != null) {
            sb.append("Action: ").append(this.actionString()).append(",");
        }
        if (this.remoteMta() != null) {
            sb.append("RemoteMta: ").append(this.remoteMta()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.diagnosticCode() != null) {
            sb.append("DiagnosticCode: ").append(this.diagnosticCode()).append(",");
        }
        if (this.lastAttemptDate() != null) {
            sb.append("LastAttemptDate: ").append(this.lastAttemptDate()).append(",");
        }
        if (this.extensionFields() != null) {
            sb.append("ExtensionFields: ").append(this.extensionFields()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FinalRecipient": {
                return Optional.of(clazz.cast(this.finalRecipient()));
            }
            case "Action": {
                return Optional.of(clazz.cast(this.actionString()));
            }
            case "RemoteMta": {
                return Optional.of(clazz.cast(this.remoteMta()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "DiagnosticCode": {
                return Optional.of(clazz.cast(this.diagnosticCode()));
            }
            case "LastAttemptDate": {
                return Optional.of(clazz.cast(this.lastAttemptDate()));
            }
            case "ExtensionFields": {
                return Optional.of(clazz.cast(this.extensionFields()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String finalRecipient;
        private String action;
        private String remoteMta;
        private String status;
        private String diagnosticCode;
        private Instant lastAttemptDate;
        private List<ExtensionField> extensionFields;

        private BuilderImpl() {
        }

        private BuilderImpl(RecipientDsnFields model) {
            this.finalRecipient(model.finalRecipient);
            this.action(model.action);
            this.remoteMta(model.remoteMta);
            this.status(model.status);
            this.diagnosticCode(model.diagnosticCode);
            this.lastAttemptDate(model.lastAttemptDate);
            this.extensionFields(model.extensionFields);
        }

        public final String getFinalRecipient() {
            return this.finalRecipient;
        }

        @Override
        public final Builder finalRecipient(String finalRecipient) {
            this.finalRecipient = finalRecipient;
            return this;
        }

        public final void setFinalRecipient(String finalRecipient) {
            this.finalRecipient = finalRecipient;
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(DsnAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getRemoteMta() {
            return this.remoteMta;
        }

        @Override
        public final Builder remoteMta(String remoteMta) {
            this.remoteMta = remoteMta;
            return this;
        }

        public final void setRemoteMta(String remoteMta) {
            this.remoteMta = remoteMta;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDiagnosticCode() {
            return this.diagnosticCode;
        }

        @Override
        public final Builder diagnosticCode(String diagnosticCode) {
            this.diagnosticCode = diagnosticCode;
            return this;
        }

        public final void setDiagnosticCode(String diagnosticCode) {
            this.diagnosticCode = diagnosticCode;
        }

        public final Instant getLastAttemptDate() {
            return this.lastAttemptDate;
        }

        @Override
        public final Builder lastAttemptDate(Instant lastAttemptDate) {
            this.lastAttemptDate = lastAttemptDate;
            return this;
        }

        public final void setLastAttemptDate(Instant lastAttemptDate) {
            this.lastAttemptDate = lastAttemptDate;
        }

        public final Collection<ExtensionField.Builder> getExtensionFields() {
            return this.extensionFields != null ? (Collection)this.extensionFields.stream().map(ExtensionField::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder extensionFields(Collection<ExtensionField> extensionFields) {
            this.extensionFields = ExtensionFieldListCopier.copy(extensionFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extensionFields(ExtensionField ... extensionFields) {
            this.extensionFields(Arrays.asList(extensionFields));
            return this;
        }

        public final void setExtensionFields(Collection<ExtensionField.BuilderImpl> extensionFields) {
            this.extensionFields = ExtensionFieldListCopier.copyFromBuilder(extensionFields);
        }

        public RecipientDsnFields build() {
            return new RecipientDsnFields(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RecipientDsnFields> {
        public Builder finalRecipient(String var1);

        public Builder action(String var1);

        public Builder action(DsnAction var1);

        public Builder remoteMta(String var1);

        public Builder status(String var1);

        public Builder diagnosticCode(String var1);

        public Builder lastAttemptDate(Instant var1);

        public Builder extensionFields(Collection<ExtensionField> var1);

        public Builder extensionFields(ExtensionField ... var1);
    }
}

