/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Optional;
import software.amazon.awssdk.services.ses.model.Body;
import software.amazon.awssdk.services.ses.model.Content;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Message
implements ToCopyableBuilder<Builder, Message> {
    private final Content subject;
    private final Body body;

    private Message(BuilderImpl builder) {
        this.subject = builder.subject;
        this.body = builder.body;
    }

    public Content subject() {
        return this.subject;
    }

    public Body body() {
        return this.body;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subject() == null ? 0 : this.subject().hashCode());
        hashCode = 31 * hashCode + (this.body() == null ? 0 : this.body().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        if (other.subject() == null ^ this.subject() == null) {
            return false;
        }
        if (other.subject() != null && !other.subject().equals(this.subject())) {
            return false;
        }
        if (other.body() == null ^ this.body() == null) {
            return false;
        }
        return other.body() == null || other.body().equals(this.body());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.subject() != null) {
            sb.append("Subject: ").append(this.subject()).append(",");
        }
        if (this.body() != null) {
            sb.append("Body: ").append(this.body()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subject": {
                return Optional.of(clazz.cast(this.subject()));
            }
            case "Body": {
                return Optional.of(clazz.cast(this.body()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Content subject;
        private Body body;

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            this.subject(model.subject);
            this.body(model.body);
        }

        public final Content.Builder getSubject() {
            return this.subject != null ? this.subject.toBuilder() : null;
        }

        @Override
        public final Builder subject(Content subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(Content.BuilderImpl subject) {
            this.subject = subject != null ? subject.build() : null;
        }

        public final Body.Builder getBody() {
            return this.body != null ? this.body.toBuilder() : null;
        }

        @Override
        public final Builder body(Body body) {
            this.body = body;
            return this;
        }

        public final void setBody(Body.BuilderImpl body) {
            this.body = body != null ? body.build() : null;
        }

        public Message build() {
            return new Message(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Message> {
        public Builder subject(Content var1);

        public Builder body(Body var1);
    }
}

