/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CloneReceiptRuleSetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CloneReceiptRuleSetRequest> {
    private final String ruleSetName;
    private final String originalRuleSetName;

    private CloneReceiptRuleSetRequest(BuilderImpl builder) {
        this.ruleSetName = builder.ruleSetName;
        this.originalRuleSetName = builder.originalRuleSetName;
    }

    public String ruleSetName() {
        return this.ruleSetName;
    }

    public String originalRuleSetName() {
        return this.originalRuleSetName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ruleSetName() == null ? 0 : this.ruleSetName().hashCode());
        hashCode = 31 * hashCode + (this.originalRuleSetName() == null ? 0 : this.originalRuleSetName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloneReceiptRuleSetRequest)) {
            return false;
        }
        CloneReceiptRuleSetRequest other = (CloneReceiptRuleSetRequest)((Object)obj);
        if (other.ruleSetName() == null ^ this.ruleSetName() == null) {
            return false;
        }
        if (other.ruleSetName() != null && !other.ruleSetName().equals(this.ruleSetName())) {
            return false;
        }
        if (other.originalRuleSetName() == null ^ this.originalRuleSetName() == null) {
            return false;
        }
        return other.originalRuleSetName() == null || other.originalRuleSetName().equals(this.originalRuleSetName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ruleSetName() != null) {
            sb.append("RuleSetName: ").append(this.ruleSetName()).append(",");
        }
        if (this.originalRuleSetName() != null) {
            sb.append("OriginalRuleSetName: ").append(this.originalRuleSetName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleSetName": {
                return Optional.of(clazz.cast(this.ruleSetName()));
            }
            case "OriginalRuleSetName": {
                return Optional.of(clazz.cast(this.originalRuleSetName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleSetName;
        private String originalRuleSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(CloneReceiptRuleSetRequest model) {
            this.ruleSetName(model.ruleSetName);
            this.originalRuleSetName(model.originalRuleSetName);
        }

        public final String getRuleSetName() {
            return this.ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final String getOriginalRuleSetName() {
            return this.originalRuleSetName;
        }

        @Override
        public final Builder originalRuleSetName(String originalRuleSetName) {
            this.originalRuleSetName = originalRuleSetName;
            return this;
        }

        public final void setOriginalRuleSetName(String originalRuleSetName) {
            this.originalRuleSetName = originalRuleSetName;
        }

        public CloneReceiptRuleSetRequest build() {
            return new CloneReceiptRuleSetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloneReceiptRuleSetRequest> {
        public Builder ruleSetName(String var1);

        public Builder originalRuleSetName(String var1);
    }
}

