/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.ReceiptAction;
import software.amazon.awssdk.services.ses.model.ReceiptRule;
import software.amazon.awssdk.services.ses.transform.ReceiptActionUnmarshaller;

public class ReceiptRuleUnmarshaller
implements Unmarshaller<ReceiptRule, StaxUnmarshallerContext> {
    private static final ReceiptRuleUnmarshaller INSTANCE = new ReceiptRuleUnmarshaller();

    public ReceiptRule unmarshall(StaxUnmarshallerContext context) throws Exception {
        ReceiptRule.Builder receiptRule;
        block11: {
            receiptRule = ReceiptRule.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> recipients = null;
            ArrayList<ReceiptAction> actions = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    receiptRule.recipients(recipients);
                    receiptRule.actions(actions);
                    break block11;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Name", targetDepth)) {
                        receiptRule.name(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Enabled", targetDepth)) {
                        receiptRule.enabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("TlsPolicy", targetDepth)) {
                        receiptRule.tlsPolicy(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Recipients", targetDepth)) {
                        recipients = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("Recipients/member", targetDepth)) {
                        recipients.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Actions", targetDepth)) {
                        actions = new ArrayList<ReceiptAction>();
                        continue;
                    }
                    if (context.testExpression("Actions/member", targetDepth)) {
                        actions.add(ReceiptActionUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("ScanEnabled", targetDepth)) continue;
                    receiptRule.scanEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            receiptRule.recipients(recipients);
            receiptRule.actions(actions);
        }
        return (ReceiptRule)receiptRule.build();
    }

    public static ReceiptRuleUnmarshaller getInstance() {
        return INSTANCE;
    }
}

