/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.ReceiptFilter;
import software.amazon.awssdk.services.ses.transform.ReceiptIpFilterUnmarshaller;

public class ReceiptFilterUnmarshaller
implements Unmarshaller<ReceiptFilter, StaxUnmarshallerContext> {
    private static final ReceiptFilterUnmarshaller INSTANCE = new ReceiptFilterUnmarshaller();

    public ReceiptFilter unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ReceiptFilter.Builder receiptFilter = ReceiptFilter.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    receiptFilter.name(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("IpFilter", targetDepth)) continue;
                receiptFilter.ipFilter(ReceiptIpFilterUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ReceiptFilter)receiptFilter.build();
    }

    public static ReceiptFilterUnmarshaller getInstance() {
        return INSTANCE;
    }
}

