/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ses.model.ListIdentitiesRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListIdentitiesRequestMarshaller
implements Marshaller<Request<ListIdentitiesRequest>, ListIdentitiesRequest> {
    public Request<ListIdentitiesRequest> marshall(ListIdentitiesRequest listIdentitiesRequest) {
        if (listIdentitiesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listIdentitiesRequest, "SESClient");
        request.addParameter("Action", "ListIdentities");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (listIdentitiesRequest.identityType() != null) {
            request.addParameter("IdentityType", StringUtils.fromString((String)listIdentitiesRequest.identityType()));
        }
        if (listIdentitiesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listIdentitiesRequest.nextToken()));
        }
        if (listIdentitiesRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)listIdentitiesRequest.maxItems()));
        }
        return request;
    }
}

