/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import software.amazon.awssdk.services.ses.model.AddHeaderAction;
import software.amazon.awssdk.services.ses.model.BounceAction;
import software.amazon.awssdk.services.ses.model.LambdaAction;
import software.amazon.awssdk.services.ses.model.S3Action;
import software.amazon.awssdk.services.ses.model.SNSAction;
import software.amazon.awssdk.services.ses.model.StopAction;
import software.amazon.awssdk.services.ses.model.WorkmailAction;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReceiptAction
implements ToCopyableBuilder<Builder, ReceiptAction> {
    private final S3Action s3Action;
    private final BounceAction bounceAction;
    private final WorkmailAction workmailAction;
    private final LambdaAction lambdaAction;
    private final StopAction stopAction;
    private final AddHeaderAction addHeaderAction;
    private final SNSAction snsAction;

    private ReceiptAction(BuilderImpl builder) {
        this.s3Action = builder.s3Action;
        this.bounceAction = builder.bounceAction;
        this.workmailAction = builder.workmailAction;
        this.lambdaAction = builder.lambdaAction;
        this.stopAction = builder.stopAction;
        this.addHeaderAction = builder.addHeaderAction;
        this.snsAction = builder.snsAction;
    }

    public S3Action s3Action() {
        return this.s3Action;
    }

    public BounceAction bounceAction() {
        return this.bounceAction;
    }

    public WorkmailAction workmailAction() {
        return this.workmailAction;
    }

    public LambdaAction lambdaAction() {
        return this.lambdaAction;
    }

    public StopAction stopAction() {
        return this.stopAction;
    }

    public AddHeaderAction addHeaderAction() {
        return this.addHeaderAction;
    }

    public SNSAction snsAction() {
        return this.snsAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.s3Action() == null ? 0 : this.s3Action().hashCode());
        hashCode = 31 * hashCode + (this.bounceAction() == null ? 0 : this.bounceAction().hashCode());
        hashCode = 31 * hashCode + (this.workmailAction() == null ? 0 : this.workmailAction().hashCode());
        hashCode = 31 * hashCode + (this.lambdaAction() == null ? 0 : this.lambdaAction().hashCode());
        hashCode = 31 * hashCode + (this.stopAction() == null ? 0 : this.stopAction().hashCode());
        hashCode = 31 * hashCode + (this.addHeaderAction() == null ? 0 : this.addHeaderAction().hashCode());
        hashCode = 31 * hashCode + (this.snsAction() == null ? 0 : this.snsAction().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiptAction)) {
            return false;
        }
        ReceiptAction other = (ReceiptAction)obj;
        if (other.s3Action() == null ^ this.s3Action() == null) {
            return false;
        }
        if (other.s3Action() != null && !other.s3Action().equals(this.s3Action())) {
            return false;
        }
        if (other.bounceAction() == null ^ this.bounceAction() == null) {
            return false;
        }
        if (other.bounceAction() != null && !other.bounceAction().equals(this.bounceAction())) {
            return false;
        }
        if (other.workmailAction() == null ^ this.workmailAction() == null) {
            return false;
        }
        if (other.workmailAction() != null && !other.workmailAction().equals(this.workmailAction())) {
            return false;
        }
        if (other.lambdaAction() == null ^ this.lambdaAction() == null) {
            return false;
        }
        if (other.lambdaAction() != null && !other.lambdaAction().equals(this.lambdaAction())) {
            return false;
        }
        if (other.stopAction() == null ^ this.stopAction() == null) {
            return false;
        }
        if (other.stopAction() != null && !other.stopAction().equals(this.stopAction())) {
            return false;
        }
        if (other.addHeaderAction() == null ^ this.addHeaderAction() == null) {
            return false;
        }
        if (other.addHeaderAction() != null && !other.addHeaderAction().equals(this.addHeaderAction())) {
            return false;
        }
        if (other.snsAction() == null ^ this.snsAction() == null) {
            return false;
        }
        return other.snsAction() == null || other.snsAction().equals(this.snsAction());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.s3Action() != null) {
            sb.append("S3Action: ").append(this.s3Action()).append(",");
        }
        if (this.bounceAction() != null) {
            sb.append("BounceAction: ").append(this.bounceAction()).append(",");
        }
        if (this.workmailAction() != null) {
            sb.append("WorkmailAction: ").append(this.workmailAction()).append(",");
        }
        if (this.lambdaAction() != null) {
            sb.append("LambdaAction: ").append(this.lambdaAction()).append(",");
        }
        if (this.stopAction() != null) {
            sb.append("StopAction: ").append(this.stopAction()).append(",");
        }
        if (this.addHeaderAction() != null) {
            sb.append("AddHeaderAction: ").append(this.addHeaderAction()).append(",");
        }
        if (this.snsAction() != null) {
            sb.append("SNSAction: ").append(this.snsAction()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private S3Action s3Action;
        private BounceAction bounceAction;
        private WorkmailAction workmailAction;
        private LambdaAction lambdaAction;
        private StopAction stopAction;
        private AddHeaderAction addHeaderAction;
        private SNSAction snsAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiptAction model) {
            this.setS3Action(model.s3Action);
            this.setBounceAction(model.bounceAction);
            this.setWorkmailAction(model.workmailAction);
            this.setLambdaAction(model.lambdaAction);
            this.setStopAction(model.stopAction);
            this.setAddHeaderAction(model.addHeaderAction);
            this.setSNSAction(model.snsAction);
        }

        public final S3Action getS3Action() {
            return this.s3Action;
        }

        @Override
        public final Builder s3Action(S3Action s3Action) {
            this.s3Action = s3Action;
            return this;
        }

        public final void setS3Action(S3Action s3Action) {
            this.s3Action = s3Action;
        }

        public final BounceAction getBounceAction() {
            return this.bounceAction;
        }

        @Override
        public final Builder bounceAction(BounceAction bounceAction) {
            this.bounceAction = bounceAction;
            return this;
        }

        public final void setBounceAction(BounceAction bounceAction) {
            this.bounceAction = bounceAction;
        }

        public final WorkmailAction getWorkmailAction() {
            return this.workmailAction;
        }

        @Override
        public final Builder workmailAction(WorkmailAction workmailAction) {
            this.workmailAction = workmailAction;
            return this;
        }

        public final void setWorkmailAction(WorkmailAction workmailAction) {
            this.workmailAction = workmailAction;
        }

        public final LambdaAction getLambdaAction() {
            return this.lambdaAction;
        }

        @Override
        public final Builder lambdaAction(LambdaAction lambdaAction) {
            this.lambdaAction = lambdaAction;
            return this;
        }

        public final void setLambdaAction(LambdaAction lambdaAction) {
            this.lambdaAction = lambdaAction;
        }

        public final StopAction getStopAction() {
            return this.stopAction;
        }

        @Override
        public final Builder stopAction(StopAction stopAction) {
            this.stopAction = stopAction;
            return this;
        }

        public final void setStopAction(StopAction stopAction) {
            this.stopAction = stopAction;
        }

        public final AddHeaderAction getAddHeaderAction() {
            return this.addHeaderAction;
        }

        @Override
        public final Builder addHeaderAction(AddHeaderAction addHeaderAction) {
            this.addHeaderAction = addHeaderAction;
            return this;
        }

        public final void setAddHeaderAction(AddHeaderAction addHeaderAction) {
            this.addHeaderAction = addHeaderAction;
        }

        public final SNSAction getSNSAction() {
            return this.snsAction;
        }

        @Override
        public final Builder snsAction(SNSAction snsAction) {
            this.snsAction = snsAction;
            return this;
        }

        public final void setSNSAction(SNSAction snsAction) {
            this.snsAction = snsAction;
        }

        public ReceiptAction build() {
            return new ReceiptAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReceiptAction> {
        public Builder s3Action(S3Action var1);

        public Builder bounceAction(BounceAction var1);

        public Builder workmailAction(WorkmailAction var1);

        public Builder lambdaAction(LambdaAction var1);

        public Builder stopAction(StopAction var1);

        public Builder addHeaderAction(AddHeaderAction var1);

        public Builder snsAction(SNSAction var1);
    }
}

