/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ses.model.VerifyEmailAddressRequest;
import software.amazon.awssdk.util.StringUtils;

public class VerifyEmailAddressRequestMarshaller
implements Marshaller<Request<VerifyEmailAddressRequest>, VerifyEmailAddressRequest> {
    public Request<VerifyEmailAddressRequest> marshall(VerifyEmailAddressRequest verifyEmailAddressRequest) {
        if (verifyEmailAddressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)verifyEmailAddressRequest, "SESClient");
        request.addParameter("Action", "VerifyEmailAddress");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (verifyEmailAddressRequest.emailAddress() != null) {
            request.addParameter("EmailAddress", StringUtils.fromString((String)verifyEmailAddressRequest.emailAddress()));
        }
        return request;
    }
}

