/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.IdentityDkimAttributes;

public class IdentityDkimAttributesUnmarshaller
implements Unmarshaller<IdentityDkimAttributes, StaxUnmarshallerContext> {
    private static IdentityDkimAttributesUnmarshaller INSTANCE;

    public IdentityDkimAttributes unmarshall(StaxUnmarshallerContext context) throws Exception {
        IdentityDkimAttributes.Builder identityDkimAttributes;
        block7: {
            identityDkimAttributes = IdentityDkimAttributes.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> dkimTokens = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    identityDkimAttributes.dkimTokens(dkimTokens);
                    break block7;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("DkimEnabled", targetDepth)) {
                        identityDkimAttributes.dkimEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DkimVerificationStatus", targetDepth)) {
                        identityDkimAttributes.dkimVerificationStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DkimTokens", targetDepth)) {
                        dkimTokens = new ArrayList<String>();
                        continue;
                    }
                    if (!context.testExpression("DkimTokens/member", targetDepth)) continue;
                    dkimTokens.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            identityDkimAttributes.dkimTokens(dkimTokens);
        }
        return (IdentityDkimAttributes)identityDkimAttributes.build();
    }

    public static IdentityDkimAttributesUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new IdentityDkimAttributesUnmarshaller();
        }
        return INSTANCE;
    }
}

