/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.CloudWatchDimensionConfiguration;

public class CloudWatchDimensionConfigurationUnmarshaller
implements Unmarshaller<CloudWatchDimensionConfiguration, StaxUnmarshallerContext> {
    private static CloudWatchDimensionConfigurationUnmarshaller INSTANCE;

    public CloudWatchDimensionConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CloudWatchDimensionConfiguration.Builder cloudWatchDimensionConfiguration = CloudWatchDimensionConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DimensionName", targetDepth)) {
                    cloudWatchDimensionConfiguration.dimensionName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DimensionValueSource", targetDepth)) {
                    cloudWatchDimensionConfiguration.dimensionValueSource(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DefaultDimensionValue", targetDepth)) continue;
                cloudWatchDimensionConfiguration.defaultDimensionValue(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CloudWatchDimensionConfiguration)cloudWatchDimensionConfiguration.build();
    }

    public static CloudWatchDimensionConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CloudWatchDimensionConfigurationUnmarshaller();
        }
        return INSTANCE;
    }
}

