/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.BounceAction;

public class BounceActionUnmarshaller
implements Unmarshaller<BounceAction, StaxUnmarshallerContext> {
    private static BounceActionUnmarshaller INSTANCE;

    public BounceAction unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        BounceAction.Builder bounceAction = BounceAction.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("TopicArn", targetDepth)) {
                    bounceAction.topicArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SmtpReplyCode", targetDepth)) {
                    bounceAction.smtpReplyCode(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StatusCode", targetDepth)) {
                    bounceAction.statusCode(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Message", targetDepth)) {
                    bounceAction.message(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Sender", targetDepth)) continue;
                bounceAction.sender(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (BounceAction)bounceAction.build();
    }

    public static BounceActionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BounceActionUnmarshaller();
        }
        return INSTANCE;
    }
}

