/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.SendCustomVerificationEmailRequest;

public class SendCustomVerificationEmailRequestMarshaller
implements Marshaller<Request<SendCustomVerificationEmailRequest>, SendCustomVerificationEmailRequest> {
    public Request<SendCustomVerificationEmailRequest> marshall(SendCustomVerificationEmailRequest sendCustomVerificationEmailRequest) {
        if (sendCustomVerificationEmailRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)sendCustomVerificationEmailRequest, "SesClient");
        request.addParameter("Action", "SendCustomVerificationEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendCustomVerificationEmailRequest.emailAddress() != null) {
            request.addParameter("EmailAddress", StringConversion.fromString((String)sendCustomVerificationEmailRequest.emailAddress()));
        }
        if (sendCustomVerificationEmailRequest.templateName() != null) {
            request.addParameter("TemplateName", StringConversion.fromString((String)sendCustomVerificationEmailRequest.templateName()));
        }
        if (sendCustomVerificationEmailRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringConversion.fromString((String)sendCustomVerificationEmailRequest.configurationSetName()));
        }
        return request;
    }
}

