/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.GetIdentityMailFromDomainAttributesRequest;

public class GetIdentityMailFromDomainAttributesRequestMarshaller
implements Marshaller<Request<GetIdentityMailFromDomainAttributesRequest>, GetIdentityMailFromDomainAttributesRequest> {
    public Request<GetIdentityMailFromDomainAttributesRequest> marshall(GetIdentityMailFromDomainAttributesRequest getIdentityMailFromDomainAttributesRequest) {
        if (getIdentityMailFromDomainAttributesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getIdentityMailFromDomainAttributesRequest, "SesClient");
        request.addParameter("Action", "GetIdentityMailFromDomainAttributes");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getIdentityMailFromDomainAttributesRequest.identities().isEmpty() && !(getIdentityMailFromDomainAttributesRequest.identities() instanceof SdkAutoConstructList)) {
            request.addParameter("Identities", "");
        } else if (!getIdentityMailFromDomainAttributesRequest.identities().isEmpty() && !(getIdentityMailFromDomainAttributesRequest.identities() instanceof SdkAutoConstructList)) {
            List<String> identitiesList = getIdentityMailFromDomainAttributesRequest.identities();
            int identitiesListIndex = 1;
            for (String identitiesListValue : identitiesList) {
                if (identitiesListValue != null) {
                    request.addParameter("Identities.member." + identitiesListIndex, StringConversion.fromString((String)identitiesListValue));
                }
                ++identitiesListIndex;
            }
        }
        return request;
    }
}

