/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.SendDataPoint;
import software.amazon.awssdk.services.ses.model.SendDataPointListCopier;
import software.amazon.awssdk.services.ses.model.SesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSendStatisticsResponse
extends SesResponse
implements ToCopyableBuilder<Builder, GetSendStatisticsResponse> {
    private final List<SendDataPoint> sendDataPoints;

    private GetSendStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.sendDataPoints = builder.sendDataPoints;
    }

    public List<SendDataPoint> sendDataPoints() {
        return this.sendDataPoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sendDataPoints());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSendStatisticsResponse)) {
            return false;
        }
        GetSendStatisticsResponse other = (GetSendStatisticsResponse)((Object)obj);
        return Objects.equals(this.sendDataPoints(), other.sendDataPoints());
    }

    public String toString() {
        return ToString.builder((String)"GetSendStatisticsResponse").add("SendDataPoints", this.sendDataPoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SendDataPoints": {
                return Optional.ofNullable(clazz.cast(this.sendDataPoints()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SesResponse.BuilderImpl
    implements Builder {
        private List<SendDataPoint> sendDataPoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSendStatisticsResponse model) {
            super(model);
            this.sendDataPoints(model.sendDataPoints);
        }

        public final Collection<SendDataPoint.Builder> getSendDataPoints() {
            return this.sendDataPoints != null ? (Collection)this.sendDataPoints.stream().map(SendDataPoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sendDataPoints(Collection<SendDataPoint> sendDataPoints) {
            this.sendDataPoints = SendDataPointListCopier.copy(sendDataPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sendDataPoints(SendDataPoint ... sendDataPoints) {
            this.sendDataPoints(Arrays.asList(sendDataPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sendDataPoints(Consumer<SendDataPoint.Builder> ... sendDataPoints) {
            this.sendDataPoints(Stream.of(sendDataPoints).map(c -> (SendDataPoint)((SendDataPoint.Builder)SendDataPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSendDataPoints(Collection<SendDataPoint.BuilderImpl> sendDataPoints) {
            this.sendDataPoints = SendDataPointListCopier.copyFromBuilder(sendDataPoints);
        }

        @Override
        public GetSendStatisticsResponse build() {
            return new GetSendStatisticsResponse(this);
        }
    }

    public static interface Builder
    extends SesResponse.Builder,
    CopyableBuilder<Builder, GetSendStatisticsResponse> {
        public Builder sendDataPoints(Collection<SendDataPoint> var1);

        public Builder sendDataPoints(SendDataPoint ... var1);

        public Builder sendDataPoints(Consumer<SendDataPoint.Builder> ... var1);
    }
}

