/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.S3Action;

public class S3ActionUnmarshaller
implements Unmarshaller<S3Action, StaxUnmarshallerContext> {
    private static final S3ActionUnmarshaller INSTANCE = new S3ActionUnmarshaller();

    public S3Action unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        S3Action.Builder s3Action = S3Action.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("TopicArn", targetDepth)) {
                    s3Action.topicArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BucketName", targetDepth)) {
                    s3Action.bucketName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ObjectKeyPrefix", targetDepth)) {
                    s3Action.objectKeyPrefix(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("KmsKeyArn", targetDepth)) continue;
                s3Action.kmsKeyArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (S3Action)s3Action.build();
    }

    public static S3ActionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

