/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.PutIdentityPolicyRequest;

public class PutIdentityPolicyRequestMarshaller
implements Marshaller<Request<PutIdentityPolicyRequest>, PutIdentityPolicyRequest> {
    public Request<PutIdentityPolicyRequest> marshall(PutIdentityPolicyRequest putIdentityPolicyRequest) {
        if (putIdentityPolicyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)putIdentityPolicyRequest, "SesClient");
        request.addParameter("Action", "PutIdentityPolicy");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putIdentityPolicyRequest.identity() != null) {
            request.addParameter("Identity", StringConversion.fromString((String)putIdentityPolicyRequest.identity()));
        }
        if (putIdentityPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringConversion.fromString((String)putIdentityPolicyRequest.policyName()));
        }
        if (putIdentityPolicyRequest.policy() != null) {
            request.addParameter("Policy", StringConversion.fromString((String)putIdentityPolicyRequest.policy()));
        }
        return request;
    }
}

