/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ses.model.GetIdentityNotificationAttributesRequest;

public class GetIdentityNotificationAttributesRequestMarshaller
implements Marshaller<Request<GetIdentityNotificationAttributesRequest>, GetIdentityNotificationAttributesRequest> {
    public Request<GetIdentityNotificationAttributesRequest> marshall(GetIdentityNotificationAttributesRequest getIdentityNotificationAttributesRequest) {
        if (getIdentityNotificationAttributesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getIdentityNotificationAttributesRequest, "SesClient");
        request.addParameter("Action", "GetIdentityNotificationAttributes");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getIdentityNotificationAttributesRequest.identities().isEmpty() && !(getIdentityNotificationAttributesRequest.identities() instanceof SdkAutoConstructList)) {
            request.addParameter("Identities", "");
        } else if (!getIdentityNotificationAttributesRequest.identities().isEmpty() && !(getIdentityNotificationAttributesRequest.identities() instanceof SdkAutoConstructList)) {
            List<String> identitiesList = getIdentityNotificationAttributesRequest.identities();
            int identitiesListIndex = 1;
            for (String identitiesListValue : identitiesList) {
                if (identitiesListValue != null) {
                    request.addParameter("Identities.member." + identitiesListIndex, StringConversion.fromString((String)identitiesListValue));
                }
                ++identitiesListIndex;
            }
        }
        return request;
    }
}

