/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ses.model.BounceType;
import software.amazon.awssdk.services.ses.model.RecipientDsnFields;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BouncedRecipientInfo
implements ToCopyableBuilder<Builder, BouncedRecipientInfo> {
    private final String recipient;
    private final String recipientArn;
    private final String bounceType;
    private final RecipientDsnFields recipientDsnFields;

    private BouncedRecipientInfo(BuilderImpl builder) {
        this.recipient = builder.recipient;
        this.recipientArn = builder.recipientArn;
        this.bounceType = builder.bounceType;
        this.recipientDsnFields = builder.recipientDsnFields;
    }

    public String recipient() {
        return this.recipient;
    }

    public String recipientArn() {
        return this.recipientArn;
    }

    public BounceType bounceType() {
        return BounceType.fromValue(this.bounceType);
    }

    public String bounceTypeAsString() {
        return this.bounceType;
    }

    public RecipientDsnFields recipientDsnFields() {
        return this.recipientDsnFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recipient());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipientArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.bounceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipientDsnFields());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BouncedRecipientInfo)) {
            return false;
        }
        BouncedRecipientInfo other = (BouncedRecipientInfo)obj;
        return Objects.equals(this.recipient(), other.recipient()) && Objects.equals(this.recipientArn(), other.recipientArn()) && Objects.equals(this.bounceTypeAsString(), other.bounceTypeAsString()) && Objects.equals(this.recipientDsnFields(), other.recipientDsnFields());
    }

    public String toString() {
        return ToString.builder((String)"BouncedRecipientInfo").add("Recipient", (Object)this.recipient()).add("RecipientArn", (Object)this.recipientArn()).add("BounceType", (Object)this.bounceTypeAsString()).add("RecipientDsnFields", (Object)this.recipientDsnFields()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Recipient": {
                return Optional.ofNullable(clazz.cast(this.recipient()));
            }
            case "RecipientArn": {
                return Optional.ofNullable(clazz.cast(this.recipientArn()));
            }
            case "BounceType": {
                return Optional.ofNullable(clazz.cast(this.bounceTypeAsString()));
            }
            case "RecipientDsnFields": {
                return Optional.ofNullable(clazz.cast(this.recipientDsnFields()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String recipient;
        private String recipientArn;
        private String bounceType;
        private RecipientDsnFields recipientDsnFields;

        private BuilderImpl() {
        }

        private BuilderImpl(BouncedRecipientInfo model) {
            this.recipient(model.recipient);
            this.recipientArn(model.recipientArn);
            this.bounceType(model.bounceType);
            this.recipientDsnFields(model.recipientDsnFields);
        }

        public final String getRecipient() {
            return this.recipient;
        }

        @Override
        public final Builder recipient(String recipient) {
            this.recipient = recipient;
            return this;
        }

        public final void setRecipient(String recipient) {
            this.recipient = recipient;
        }

        public final String getRecipientArn() {
            return this.recipientArn;
        }

        @Override
        public final Builder recipientArn(String recipientArn) {
            this.recipientArn = recipientArn;
            return this;
        }

        public final void setRecipientArn(String recipientArn) {
            this.recipientArn = recipientArn;
        }

        public final String getBounceType() {
            return this.bounceType;
        }

        @Override
        public final Builder bounceType(String bounceType) {
            this.bounceType = bounceType;
            return this;
        }

        @Override
        public final Builder bounceType(BounceType bounceType) {
            this.bounceType(bounceType.toString());
            return this;
        }

        public final void setBounceType(String bounceType) {
            this.bounceType = bounceType;
        }

        public final RecipientDsnFields.Builder getRecipientDsnFields() {
            return this.recipientDsnFields != null ? this.recipientDsnFields.toBuilder() : null;
        }

        @Override
        public final Builder recipientDsnFields(RecipientDsnFields recipientDsnFields) {
            this.recipientDsnFields = recipientDsnFields;
            return this;
        }

        public final void setRecipientDsnFields(RecipientDsnFields.BuilderImpl recipientDsnFields) {
            this.recipientDsnFields = recipientDsnFields != null ? recipientDsnFields.build() : null;
        }

        public BouncedRecipientInfo build() {
            return new BouncedRecipientInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BouncedRecipientInfo> {
        public Builder recipient(String var1);

        public Builder recipientArn(String var1);

        public Builder bounceType(String var1);

        public Builder bounceType(BounceType var1);

        public Builder recipientDsnFields(RecipientDsnFields var1);

        default public Builder recipientDsnFields(Consumer<RecipientDsnFields.Builder> recipientDsnFields) {
            return this.recipientDsnFields((RecipientDsnFields)((RecipientDsnFields.Builder)RecipientDsnFields.builder().applyMutation(recipientDsnFields)).build());
        }
    }
}

