/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ses.model.Template;

public class TemplateUnmarshaller
implements Unmarshaller<Template, StaxUnmarshallerContext> {
    private static final TemplateUnmarshaller INSTANCE = new TemplateUnmarshaller();

    public Template unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Template.Builder template = Template.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("TemplateName", targetDepth)) {
                    template.templateName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SubjectPart", targetDepth)) {
                    template.subjectPart(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TextPart", targetDepth)) {
                    template.textPart(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("HtmlPart", targetDepth)) continue;
                template.htmlPart(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Template)template.build();
    }

    public static TemplateUnmarshaller getInstance() {
        return INSTANCE;
    }
}

