/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ses.model.GetTemplateRequest;

public class GetTemplateRequestMarshaller
implements Marshaller<Request<GetTemplateRequest>, GetTemplateRequest> {
    public Request<GetTemplateRequest> marshall(GetTemplateRequest getTemplateRequest) {
        if (getTemplateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)getTemplateRequest, "SESClient");
        request.addParameter("Action", "GetTemplate");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getTemplateRequest.templateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString((String)getTemplateRequest.templateName()));
        }
        return request;
    }
}

