/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ses.model.ReceiptRule;
import software.amazon.awssdk.services.ses.model.SESRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateReceiptRuleRequest
extends SESRequest
implements ToCopyableBuilder<Builder, UpdateReceiptRuleRequest> {
    private final String ruleSetName;
    private final ReceiptRule rule;

    private UpdateReceiptRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleSetName = builder.ruleSetName;
        this.rule = builder.rule;
    }

    public String ruleSetName() {
        return this.ruleSetName;
    }

    public ReceiptRule rule() {
        return this.rule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.rule());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReceiptRuleRequest)) {
            return false;
        }
        UpdateReceiptRuleRequest other = (UpdateReceiptRuleRequest)((Object)obj);
        return Objects.equals(this.ruleSetName(), other.ruleSetName()) && Objects.equals(this.rule(), other.rule());
    }

    public String toString() {
        return ToString.builder((String)"UpdateReceiptRuleRequest").add("RuleSetName", (Object)this.ruleSetName()).add("Rule", (Object)this.rule()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleSetName": {
                return Optional.of(clazz.cast(this.ruleSetName()));
            }
            case "Rule": {
                return Optional.of(clazz.cast(this.rule()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESRequest.BuilderImpl
    implements Builder {
        private String ruleSetName;
        private ReceiptRule rule;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReceiptRuleRequest model) {
            super(model);
            this.ruleSetName(model.ruleSetName);
            this.rule(model.rule);
        }

        public final String getRuleSetName() {
            return this.ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final ReceiptRule.Builder getRule() {
            return this.rule != null ? this.rule.toBuilder() : null;
        }

        @Override
        public final Builder rule(ReceiptRule rule) {
            this.rule = rule;
            return this;
        }

        public final void setRule(ReceiptRule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateReceiptRuleRequest build() {
            return new UpdateReceiptRuleRequest(this);
        }
    }

    public static interface Builder
    extends SESRequest.Builder,
    CopyableBuilder<Builder, UpdateReceiptRuleRequest> {
        public Builder ruleSetName(String var1);

        public Builder rule(ReceiptRule var1);

        default public Builder rule(Consumer<ReceiptRule.Builder> rule) {
            return this.rule((ReceiptRule)((ReceiptRule.Builder)ReceiptRule.builder().apply(rule)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

