/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ses.model.SESRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutIdentityPolicyRequest
extends SESRequest
implements ToCopyableBuilder<Builder, PutIdentityPolicyRequest> {
    private final String identity;
    private final String policyName;
    private final String policy;

    private PutIdentityPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.identity = builder.identity;
        this.policyName = builder.policyName;
        this.policy = builder.policy;
    }

    public String identity() {
        return this.identity;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policy() {
        return this.policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identity());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIdentityPolicyRequest)) {
            return false;
        }
        PutIdentityPolicyRequest other = (PutIdentityPolicyRequest)((Object)obj);
        return Objects.equals(this.identity(), other.identity()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policy(), other.policy());
    }

    public String toString() {
        return ToString.builder((String)"PutIdentityPolicyRequest").add("Identity", (Object)this.identity()).add("PolicyName", (Object)this.policyName()).add("Policy", (Object)this.policy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identity": {
                return Optional.of(clazz.cast(this.identity()));
            }
            case "PolicyName": {
                return Optional.of(clazz.cast(this.policyName()));
            }
            case "Policy": {
                return Optional.of(clazz.cast(this.policy()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SESRequest.BuilderImpl
    implements Builder {
        private String identity;
        private String policyName;
        private String policy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutIdentityPolicyRequest model) {
            super(model);
            this.identity(model.identity);
            this.policyName(model.policyName);
            this.policy(model.policy);
        }

        public final String getIdentity() {
            return this.identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicy() {
            return this.policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutIdentityPolicyRequest build() {
            return new PutIdentityPolicyRequest(this);
        }
    }

    public static interface Builder
    extends SESRequest.Builder,
    CopyableBuilder<Builder, PutIdentityPolicyRequest> {
        public Builder identity(String var1);

        public Builder policyName(String var1);

        public Builder policy(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

