/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Content
implements ToCopyableBuilder<Builder, Content> {
    private final String data;
    private final String charset;

    private Content(BuilderImpl builder) {
        this.data = builder.data;
        this.charset = builder.charset;
    }

    public String data() {
        return this.data;
    }

    public String charset() {
        return this.charset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.charset());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Content)) {
            return false;
        }
        Content other = (Content)obj;
        return Objects.equals(this.data(), other.data()) && Objects.equals(this.charset(), other.charset());
    }

    public String toString() {
        return ToString.builder((String)"Content").add("Data", (Object)this.data()).add("Charset", (Object)this.charset()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Data": {
                return Optional.of(clazz.cast(this.data()));
            }
            case "Charset": {
                return Optional.of(clazz.cast(this.charset()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String data;
        private String charset;

        private BuilderImpl() {
        }

        private BuilderImpl(Content model) {
            this.data(model.data);
            this.charset(model.charset);
        }

        public final String getData() {
            return this.data;
        }

        @Override
        public final Builder data(String data) {
            this.data = data;
            return this;
        }

        public final void setData(String data) {
            this.data = data;
        }

        public final String getCharset() {
            return this.charset;
        }

        @Override
        public final Builder charset(String charset) {
            this.charset = charset;
            return this;
        }

        public final void setCharset(String charset) {
            this.charset = charset;
        }

        public Content build() {
            return new Content(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Content> {
        public Builder data(String var1);

        public Builder charset(String var1);
    }
}

