/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import java.util.Date;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ses.model.BouncedRecipientInfo;
import software.amazon.awssdk.services.ses.model.ExtensionField;
import software.amazon.awssdk.services.ses.model.MessageDsn;
import software.amazon.awssdk.services.ses.model.RecipientDsnFields;
import software.amazon.awssdk.services.ses.model.SendBounceRequest;
import software.amazon.awssdk.util.StringUtils;

public class SendBounceRequestMarshaller
implements Marshaller<Request<SendBounceRequest>, SendBounceRequest> {
    public Request<SendBounceRequest> marshall(SendBounceRequest sendBounceRequest) {
        SdkInternalList bouncedRecipientInfoListList;
        MessageDsn messageDsn;
        if (sendBounceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)sendBounceRequest, "SESClient");
        request.addParameter("Action", "SendBounce");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendBounceRequest.originalMessageId() != null) {
            request.addParameter("OriginalMessageId", StringUtils.fromString((String)sendBounceRequest.originalMessageId()));
        }
        if (sendBounceRequest.bounceSender() != null) {
            request.addParameter("BounceSender", StringUtils.fromString((String)sendBounceRequest.bounceSender()));
        }
        if (sendBounceRequest.explanation() != null) {
            request.addParameter("Explanation", StringUtils.fromString((String)sendBounceRequest.explanation()));
        }
        if ((messageDsn = sendBounceRequest.messageDsn()) != null) {
            SdkInternalList extensionFieldsList;
            if (messageDsn.reportingMta() != null) {
                request.addParameter("MessageDsn.ReportingMta", StringUtils.fromString((String)messageDsn.reportingMta()));
            }
            if (messageDsn.arrivalDate() != null) {
                request.addParameter("MessageDsn.ArrivalDate", StringUtils.fromDate((Date)messageDsn.arrivalDate()));
            }
            if (!(extensionFieldsList = (SdkInternalList)messageDsn.extensionFields()).isEmpty() || !extensionFieldsList.isAutoConstruct()) {
                int extensionFieldsListIndex = 1;
                for (ExtensionField extensionFieldsListValue : extensionFieldsList) {
                    if (extensionFieldsListValue.name() != null) {
                        request.addParameter("MessageDsn.ExtensionFields.member." + extensionFieldsListIndex + ".Name", StringUtils.fromString((String)extensionFieldsListValue.name()));
                    }
                    if (extensionFieldsListValue.value() != null) {
                        request.addParameter("MessageDsn.ExtensionFields.member." + extensionFieldsListIndex + ".Value", StringUtils.fromString((String)extensionFieldsListValue.value()));
                    }
                    ++extensionFieldsListIndex;
                }
            }
        }
        if (!(bouncedRecipientInfoListList = (SdkInternalList)sendBounceRequest.bouncedRecipientInfoList()).isEmpty() || !bouncedRecipientInfoListList.isAutoConstruct()) {
            int bouncedRecipientInfoListListIndex = 1;
            for (BouncedRecipientInfo bouncedRecipientInfoListListValue : bouncedRecipientInfoListList) {
                RecipientDsnFields recipientDsnFields;
                if (bouncedRecipientInfoListListValue.recipient() != null) {
                    request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".Recipient", StringUtils.fromString((String)bouncedRecipientInfoListListValue.recipient()));
                }
                if (bouncedRecipientInfoListListValue.recipientArn() != null) {
                    request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientArn", StringUtils.fromString((String)bouncedRecipientInfoListListValue.recipientArn()));
                }
                if (bouncedRecipientInfoListListValue.bounceType() != null) {
                    request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".BounceType", StringUtils.fromString((String)bouncedRecipientInfoListListValue.bounceType()));
                }
                if ((recipientDsnFields = bouncedRecipientInfoListListValue.recipientDsnFields()) != null) {
                    SdkInternalList extensionFieldsList;
                    if (recipientDsnFields.finalRecipient() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.FinalRecipient", StringUtils.fromString((String)recipientDsnFields.finalRecipient()));
                    }
                    if (recipientDsnFields.action() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.Action", StringUtils.fromString((String)recipientDsnFields.action()));
                    }
                    if (recipientDsnFields.remoteMta() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.RemoteMta", StringUtils.fromString((String)recipientDsnFields.remoteMta()));
                    }
                    if (recipientDsnFields.status() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.Status", StringUtils.fromString((String)recipientDsnFields.status()));
                    }
                    if (recipientDsnFields.diagnosticCode() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.DiagnosticCode", StringUtils.fromString((String)recipientDsnFields.diagnosticCode()));
                    }
                    if (recipientDsnFields.lastAttemptDate() != null) {
                        request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.LastAttemptDate", StringUtils.fromDate((Date)recipientDsnFields.lastAttemptDate()));
                    }
                    if (!(extensionFieldsList = (SdkInternalList)recipientDsnFields.extensionFields()).isEmpty() || !extensionFieldsList.isAutoConstruct()) {
                        int extensionFieldsListIndex = 1;
                        for (ExtensionField extensionFieldsListValue : extensionFieldsList) {
                            if (extensionFieldsListValue.name() != null) {
                                request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.ExtensionFields.member." + extensionFieldsListIndex + ".Name", StringUtils.fromString((String)extensionFieldsListValue.name()));
                            }
                            if (extensionFieldsListValue.value() != null) {
                                request.addParameter("BouncedRecipientInfoList.member." + bouncedRecipientInfoListListIndex + ".RecipientDsnFields.ExtensionFields.member." + extensionFieldsListIndex + ".Value", StringUtils.fromString((String)extensionFieldsListValue.value()));
                            }
                            ++extensionFieldsListIndex;
                        }
                    }
                }
                ++bouncedRecipientInfoListListIndex;
            }
        }
        if (sendBounceRequest.bounceSenderArn() != null) {
            request.addParameter("BounceSenderArn", StringUtils.fromString((String)sendBounceRequest.bounceSenderArn()));
        }
        return request;
    }
}

