/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ses.model.GetIdentityNotificationAttributesRequest;
import software.amazon.awssdk.util.StringUtils;

public class GetIdentityNotificationAttributesRequestMarshaller
implements Marshaller<Request<GetIdentityNotificationAttributesRequest>, GetIdentityNotificationAttributesRequest> {
    public Request<GetIdentityNotificationAttributesRequest> marshall(GetIdentityNotificationAttributesRequest getIdentityNotificationAttributesRequest) {
        if (getIdentityNotificationAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getIdentityNotificationAttributesRequest, "SESClient");
        request.addParameter("Action", "GetIdentityNotificationAttributes");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList identitiesList = (SdkInternalList)getIdentityNotificationAttributesRequest.identities();
        if (!identitiesList.isEmpty() || !identitiesList.isAutoConstruct()) {
            int identitiesListIndex = 1;
            for (String identitiesListValue : identitiesList) {
                if (identitiesListValue != null) {
                    request.addParameter("Identities.member." + identitiesListIndex, StringUtils.fromString((String)identitiesListValue));
                }
                ++identitiesListIndex;
            }
        }
        return request;
    }
}

