/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ses.model.CloneReceiptRuleSetRequest;
import software.amazon.awssdk.util.StringUtils;

public class CloneReceiptRuleSetRequestMarshaller
implements Marshaller<Request<CloneReceiptRuleSetRequest>, CloneReceiptRuleSetRequest> {
    public Request<CloneReceiptRuleSetRequest> marshall(CloneReceiptRuleSetRequest cloneReceiptRuleSetRequest) {
        if (cloneReceiptRuleSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)cloneReceiptRuleSetRequest, "SESClient");
        request.addParameter("Action", "CloneReceiptRuleSet");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (cloneReceiptRuleSetRequest.ruleSetName() != null) {
            request.addParameter("RuleSetName", StringUtils.fromString((String)cloneReceiptRuleSetRequest.ruleSetName()));
        }
        if (cloneReceiptRuleSetRequest.originalRuleSetName() != null) {
            request.addParameter("OriginalRuleSetName", StringUtils.fromString((String)cloneReceiptRuleSetRequest.originalRuleSetName()));
        }
        return request;
    }
}

