/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ses.model.AddressListCopier;
import software.amazon.awssdk.services.ses.model.Destination;
import software.amazon.awssdk.services.ses.model.Message;
import software.amazon.awssdk.services.ses.model.MessageTag;
import software.amazon.awssdk.services.ses.model.MessageTagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SendEmailRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SendEmailRequest> {
    private final String source;
    private final Destination destination;
    private final Message message;
    private final List<String> replyToAddresses;
    private final String returnPath;
    private final String sourceArn;
    private final String returnPathArn;
    private final List<MessageTag> tags;
    private final String configurationSetName;

    private SendEmailRequest(BuilderImpl builder) {
        this.source = builder.source;
        this.destination = builder.destination;
        this.message = builder.message;
        this.replyToAddresses = builder.replyToAddresses;
        this.returnPath = builder.returnPath;
        this.sourceArn = builder.sourceArn;
        this.returnPathArn = builder.returnPathArn;
        this.tags = builder.tags;
        this.configurationSetName = builder.configurationSetName;
    }

    public String source() {
        return this.source;
    }

    public Destination destination() {
        return this.destination;
    }

    public Message message() {
        return this.message;
    }

    public List<String> replyToAddresses() {
        return this.replyToAddresses;
    }

    public String returnPath() {
        return this.returnPath;
    }

    public String sourceArn() {
        return this.sourceArn;
    }

    public String returnPathArn() {
        return this.returnPathArn;
    }

    public List<MessageTag> tags() {
        return this.tags;
    }

    public String configurationSetName() {
        return this.configurationSetName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.source() == null ? 0 : this.source().hashCode());
        hashCode = 31 * hashCode + (this.destination() == null ? 0 : this.destination().hashCode());
        hashCode = 31 * hashCode + (this.message() == null ? 0 : this.message().hashCode());
        hashCode = 31 * hashCode + (this.replyToAddresses() == null ? 0 : this.replyToAddresses().hashCode());
        hashCode = 31 * hashCode + (this.returnPath() == null ? 0 : this.returnPath().hashCode());
        hashCode = 31 * hashCode + (this.sourceArn() == null ? 0 : this.sourceArn().hashCode());
        hashCode = 31 * hashCode + (this.returnPathArn() == null ? 0 : this.returnPathArn().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.configurationSetName() == null ? 0 : this.configurationSetName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendEmailRequest)) {
            return false;
        }
        SendEmailRequest other = (SendEmailRequest)((Object)obj);
        if (other.source() == null ^ this.source() == null) {
            return false;
        }
        if (other.source() != null && !other.source().equals(this.source())) {
            return false;
        }
        if (other.destination() == null ^ this.destination() == null) {
            return false;
        }
        if (other.destination() != null && !other.destination().equals(this.destination())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.replyToAddresses() == null ^ this.replyToAddresses() == null) {
            return false;
        }
        if (other.replyToAddresses() != null && !other.replyToAddresses().equals(this.replyToAddresses())) {
            return false;
        }
        if (other.returnPath() == null ^ this.returnPath() == null) {
            return false;
        }
        if (other.returnPath() != null && !other.returnPath().equals(this.returnPath())) {
            return false;
        }
        if (other.sourceArn() == null ^ this.sourceArn() == null) {
            return false;
        }
        if (other.sourceArn() != null && !other.sourceArn().equals(this.sourceArn())) {
            return false;
        }
        if (other.returnPathArn() == null ^ this.returnPathArn() == null) {
            return false;
        }
        if (other.returnPathArn() != null && !other.returnPathArn().equals(this.returnPathArn())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.configurationSetName() == null ^ this.configurationSetName() == null) {
            return false;
        }
        return other.configurationSetName() == null || other.configurationSetName().equals(this.configurationSetName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.source() != null) {
            sb.append("Source: ").append(this.source()).append(",");
        }
        if (this.destination() != null) {
            sb.append("Destination: ").append(this.destination()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (this.replyToAddresses() != null) {
            sb.append("ReplyToAddresses: ").append(this.replyToAddresses()).append(",");
        }
        if (this.returnPath() != null) {
            sb.append("ReturnPath: ").append(this.returnPath()).append(",");
        }
        if (this.sourceArn() != null) {
            sb.append("SourceArn: ").append(this.sourceArn()).append(",");
        }
        if (this.returnPathArn() != null) {
            sb.append("ReturnPathArn: ").append(this.returnPathArn()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.configurationSetName() != null) {
            sb.append("ConfigurationSetName: ").append(this.configurationSetName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String source;
        private Destination destination;
        private Message message;
        private List<String> replyToAddresses = new SdkInternalList();
        private String returnPath;
        private String sourceArn;
        private String returnPathArn;
        private List<MessageTag> tags = new SdkInternalList();
        private String configurationSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(SendEmailRequest model) {
            this.setSource(model.source);
            this.setDestination(model.destination);
            this.setMessage(model.message);
            this.setReplyToAddresses(model.replyToAddresses);
            this.setReturnPath(model.returnPath);
            this.setSourceArn(model.sourceArn);
            this.setReturnPathArn(model.returnPathArn);
            this.setTags(model.tags);
            this.setConfigurationSetName(model.configurationSetName);
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final Destination getDestination() {
            return this.destination;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(Destination destination) {
            this.destination = destination;
        }

        public final Message getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(Message message) {
            this.message = message;
            return this;
        }

        public final void setMessage(Message message) {
            this.message = message;
        }

        public final Collection<String> getReplyToAddresses() {
            return this.replyToAddresses;
        }

        @Override
        public final Builder replyToAddresses(Collection<String> replyToAddresses) {
            this.replyToAddresses = AddressListCopier.copy(replyToAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replyToAddresses(String ... replyToAddresses) {
            if (this.replyToAddresses == null) {
                this.replyToAddresses = new SdkInternalList(replyToAddresses.length);
            }
            for (String e : replyToAddresses) {
                this.replyToAddresses.add(e);
            }
            return this;
        }

        public final void setReplyToAddresses(Collection<String> replyToAddresses) {
            this.replyToAddresses = AddressListCopier.copy(replyToAddresses);
        }

        @SafeVarargs
        public final void setReplyToAddresses(String ... replyToAddresses) {
            if (this.replyToAddresses == null) {
                this.replyToAddresses = new SdkInternalList(replyToAddresses.length);
            }
            for (String e : replyToAddresses) {
                this.replyToAddresses.add(e);
            }
        }

        public final String getReturnPath() {
            return this.returnPath;
        }

        @Override
        public final Builder returnPath(String returnPath) {
            this.returnPath = returnPath;
            return this;
        }

        public final void setReturnPath(String returnPath) {
            this.returnPath = returnPath;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final String getReturnPathArn() {
            return this.returnPathArn;
        }

        @Override
        public final Builder returnPathArn(String returnPathArn) {
            this.returnPathArn = returnPathArn;
            return this;
        }

        public final void setReturnPathArn(String returnPathArn) {
            this.returnPathArn = returnPathArn;
        }

        public final Collection<MessageTag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<MessageTag> tags) {
            this.tags = MessageTagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(MessageTag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (MessageTag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<MessageTag> tags) {
            this.tags = MessageTagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(MessageTag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (MessageTag e : tags) {
                this.tags.add(e);
            }
        }

        public final String getConfigurationSetName() {
            return this.configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public SendEmailRequest build() {
            return new SendEmailRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SendEmailRequest> {
        public Builder source(String var1);

        public Builder destination(Destination var1);

        public Builder message(Message var1);

        public Builder replyToAddresses(Collection<String> var1);

        public Builder replyToAddresses(String ... var1);

        public Builder returnPath(String var1);

        public Builder sourceArn(String var1);

        public Builder returnPathArn(String var1);

        public Builder tags(Collection<MessageTag> var1);

        public Builder tags(MessageTag ... var1);

        public Builder configurationSetName(String var1);
    }
}

