/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ses.model.ExtensionField;
import software.amazon.awssdk.services.ses.model.ExtensionFieldListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MessageDsn
implements ToCopyableBuilder<Builder, MessageDsn> {
    private final String reportingMta;
    private final Date arrivalDate;
    private final List<ExtensionField> extensionFields;

    private MessageDsn(BuilderImpl builder) {
        this.reportingMta = builder.reportingMta;
        this.arrivalDate = builder.arrivalDate;
        this.extensionFields = builder.extensionFields;
    }

    public String reportingMta() {
        return this.reportingMta;
    }

    public Date arrivalDate() {
        return this.arrivalDate;
    }

    public List<ExtensionField> extensionFields() {
        return this.extensionFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.reportingMta() == null ? 0 : this.reportingMta().hashCode());
        hashCode = 31 * hashCode + (this.arrivalDate() == null ? 0 : this.arrivalDate().hashCode());
        hashCode = 31 * hashCode + (this.extensionFields() == null ? 0 : this.extensionFields().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageDsn)) {
            return false;
        }
        MessageDsn other = (MessageDsn)obj;
        if (other.reportingMta() == null ^ this.reportingMta() == null) {
            return false;
        }
        if (other.reportingMta() != null && !other.reportingMta().equals(this.reportingMta())) {
            return false;
        }
        if (other.arrivalDate() == null ^ this.arrivalDate() == null) {
            return false;
        }
        if (other.arrivalDate() != null && !other.arrivalDate().equals(this.arrivalDate())) {
            return false;
        }
        if (other.extensionFields() == null ^ this.extensionFields() == null) {
            return false;
        }
        return other.extensionFields() == null || other.extensionFields().equals(this.extensionFields());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.reportingMta() != null) {
            sb.append("ReportingMta: ").append(this.reportingMta()).append(",");
        }
        if (this.arrivalDate() != null) {
            sb.append("ArrivalDate: ").append(this.arrivalDate()).append(",");
        }
        if (this.extensionFields() != null) {
            sb.append("ExtensionFields: ").append(this.extensionFields()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String reportingMta;
        private Date arrivalDate;
        private List<ExtensionField> extensionFields = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(MessageDsn model) {
            this.setReportingMta(model.reportingMta);
            this.setArrivalDate(model.arrivalDate);
            this.setExtensionFields(model.extensionFields);
        }

        public final String getReportingMta() {
            return this.reportingMta;
        }

        @Override
        public final Builder reportingMta(String reportingMta) {
            this.reportingMta = reportingMta;
            return this;
        }

        public final void setReportingMta(String reportingMta) {
            this.reportingMta = reportingMta;
        }

        public final Date getArrivalDate() {
            return this.arrivalDate;
        }

        @Override
        public final Builder arrivalDate(Date arrivalDate) {
            this.arrivalDate = StandardMemberCopier.copy((Date)arrivalDate);
            return this;
        }

        public final void setArrivalDate(Date arrivalDate) {
            this.arrivalDate = StandardMemberCopier.copy((Date)arrivalDate);
        }

        public final Collection<ExtensionField> getExtensionFields() {
            return this.extensionFields;
        }

        @Override
        public final Builder extensionFields(Collection<ExtensionField> extensionFields) {
            this.extensionFields = ExtensionFieldListCopier.copy(extensionFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extensionFields(ExtensionField ... extensionFields) {
            if (this.extensionFields == null) {
                this.extensionFields = new SdkInternalList(extensionFields.length);
            }
            for (ExtensionField e : extensionFields) {
                this.extensionFields.add(e);
            }
            return this;
        }

        public final void setExtensionFields(Collection<ExtensionField> extensionFields) {
            this.extensionFields = ExtensionFieldListCopier.copy(extensionFields);
        }

        @SafeVarargs
        public final void setExtensionFields(ExtensionField ... extensionFields) {
            if (this.extensionFields == null) {
                this.extensionFields = new SdkInternalList(extensionFields.length);
            }
            for (ExtensionField e : extensionFields) {
                this.extensionFields.add(e);
            }
        }

        public MessageDsn build() {
            return new MessageDsn(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MessageDsn> {
        public Builder reportingMta(String var1);

        public Builder arrivalDate(Date var1);

        public Builder extensionFields(Collection<ExtensionField> var1);

        public Builder extensionFields(ExtensionField ... var1);
    }
}

