/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import software.amazon.awssdk.services.ses.model.Body;
import software.amazon.awssdk.services.ses.model.Content;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Message
implements ToCopyableBuilder<Builder, Message> {
    private final Content subject;
    private final Body body;

    private Message(BuilderImpl builder) {
        this.subject = builder.subject;
        this.body = builder.body;
    }

    public Content subject() {
        return this.subject;
    }

    public Body body() {
        return this.body;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subject() == null ? 0 : this.subject().hashCode());
        hashCode = 31 * hashCode + (this.body() == null ? 0 : this.body().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        if (other.subject() == null ^ this.subject() == null) {
            return false;
        }
        if (other.subject() != null && !other.subject().equals(this.subject())) {
            return false;
        }
        if (other.body() == null ^ this.body() == null) {
            return false;
        }
        return other.body() == null || other.body().equals(this.body());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.subject() != null) {
            sb.append("Subject: ").append(this.subject()).append(",");
        }
        if (this.body() != null) {
            sb.append("Body: ").append(this.body()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Content subject;
        private Body body;

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            this.setSubject(model.subject);
            this.setBody(model.body);
        }

        public final Content getSubject() {
            return this.subject;
        }

        @Override
        public final Builder subject(Content subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(Content subject) {
            this.subject = subject;
        }

        public final Body getBody() {
            return this.body;
        }

        @Override
        public final Builder body(Body body) {
            this.body = body;
            return this;
        }

        public final void setBody(Body body) {
            this.body = body;
        }

        public Message build() {
            return new Message(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Message> {
        public Builder subject(Content var1);

        public Builder body(Body var1);
    }
}

