/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import software.amazon.awssdk.services.ses.model.Content;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Body
implements ToCopyableBuilder<Builder, Body> {
    private final Content text;
    private final Content html;

    private Body(BuilderImpl builder) {
        this.text = builder.text;
        this.html = builder.html;
    }

    public Content text() {
        return this.text;
    }

    public Content html() {
        return this.html;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.text() == null ? 0 : this.text().hashCode());
        hashCode = 31 * hashCode + (this.html() == null ? 0 : this.html().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Body)) {
            return false;
        }
        Body other = (Body)obj;
        if (other.text() == null ^ this.text() == null) {
            return false;
        }
        if (other.text() != null && !other.text().equals(this.text())) {
            return false;
        }
        if (other.html() == null ^ this.html() == null) {
            return false;
        }
        return other.html() == null || other.html().equals(this.html());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.text() != null) {
            sb.append("Text: ").append(this.text()).append(",");
        }
        if (this.html() != null) {
            sb.append("Html: ").append(this.html()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Content text;
        private Content html;

        private BuilderImpl() {
        }

        private BuilderImpl(Body model) {
            this.setText(model.text);
            this.setHtml(model.html);
        }

        public final Content getText() {
            return this.text;
        }

        @Override
        public final Builder text(Content text) {
            this.text = text;
            return this;
        }

        public final void setText(Content text) {
            this.text = text;
        }

        public final Content getHtml() {
            return this.html;
        }

        @Override
        public final Builder html(Content html) {
            this.html = html;
            return this;
        }

        public final void setHtml(Content html) {
            this.html = html;
        }

        public Body build() {
            return new Body(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Body> {
        public Builder text(Content var1);

        public Builder html(Content var1);
    }
}

