/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicequotas.ServiceQuotasClient;
import software.amazon.awssdk.services.servicequotas.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest;
import software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuota;

public class ListAWSDefaultServiceQuotasIterable
implements SdkIterable<ListAwsDefaultServiceQuotasResponse> {
    private final ServiceQuotasClient client;
    private final ListAwsDefaultServiceQuotasRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAWSDefaultServiceQuotasIterable(ServiceQuotasClient client, ListAwsDefaultServiceQuotasRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAwsDefaultServiceQuotasResponseFetcher();
    }

    public Iterator<ListAwsDefaultServiceQuotasResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceQuota> quotas() {
        Function<ListAwsDefaultServiceQuotasResponse, Iterator> getIterator = response -> {
            if (response != null && response.quotas() != null) {
                return response.quotas().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAwsDefaultServiceQuotasResponseFetcher
    implements SyncPageFetcher<ListAwsDefaultServiceQuotasResponse> {
        private ListAwsDefaultServiceQuotasResponseFetcher() {
        }

        public boolean hasNextPage(ListAwsDefaultServiceQuotasResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAwsDefaultServiceQuotasResponse nextPage(ListAwsDefaultServiceQuotasResponse previousPage) {
            if (previousPage == null) {
                return ListAWSDefaultServiceQuotasIterable.this.client.listAWSDefaultServiceQuotas(ListAWSDefaultServiceQuotasIterable.this.firstRequest);
            }
            return ListAWSDefaultServiceQuotasIterable.this.client.listAWSDefaultServiceQuotas((ListAwsDefaultServiceQuotasRequest)((Object)ListAWSDefaultServiceQuotasIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

