/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicediscovery.model.NamespaceProperties;
import software.amazon.awssdk.services.servicediscovery.model.NamespaceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Namespace
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Namespace> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Namespace.getter(Namespace::id)).setter(Namespace.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Namespace.getter(Namespace::arn)).setter(Namespace.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Namespace.getter(Namespace::name)).setter(Namespace.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Namespace.getter(Namespace::typeAsString)).setter(Namespace.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Namespace.getter(Namespace::description)).setter(Namespace.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Integer> SERVICE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Namespace.getter(Namespace::serviceCount)).setter(Namespace.setter(Builder::serviceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCount").build()}).build();
    private static final SdkField<NamespaceProperties> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Namespace.getter(Namespace::properties)).setter(Namespace.setter(Builder::properties)).constructor(NamespaceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Namespace.getter(Namespace::createDate)).setter(Namespace.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Namespace.getter(Namespace::creatorRequestId)).setter(Namespace.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, NAME_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, SERVICE_COUNT_FIELD, PROPERTIES_FIELD, CREATE_DATE_FIELD, CREATOR_REQUEST_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String name;
    private final String type;
    private final String description;
    private final Integer serviceCount;
    private final NamespaceProperties properties;
    private final Instant createDate;
    private final String creatorRequestId;

    private Namespace(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.description = builder.description;
        this.serviceCount = builder.serviceCount;
        this.properties = builder.properties;
        this.createDate = builder.createDate;
        this.creatorRequestId = builder.creatorRequestId;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public NamespaceType type() {
        return NamespaceType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String description() {
        return this.description;
    }

    public Integer serviceCount() {
        return this.serviceCount;
    }

    public NamespaceProperties properties() {
        return this.properties;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public String creatorRequestId() {
        return this.creatorRequestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.properties());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Namespace)) {
            return false;
        }
        Namespace other = (Namespace)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.serviceCount(), other.serviceCount()) && Objects.equals(this.properties(), other.properties()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId());
    }

    public String toString() {
        return ToString.builder((String)"Namespace").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Description", (Object)this.description()).add("ServiceCount", (Object)this.serviceCount()).add("Properties", (Object)this.properties()).add("CreateDate", (Object)this.createDate()).add("CreatorRequestId", (Object)this.creatorRequestId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ServiceCount": {
                return Optional.ofNullable(clazz.cast(this.serviceCount()));
            }
            case "Properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Namespace, T> g) {
        return obj -> g.apply((Namespace)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String name;
        private String type;
        private String description;
        private Integer serviceCount;
        private NamespaceProperties properties;
        private Instant createDate;
        private String creatorRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(Namespace model) {
            this.id(model.id);
            this.arn(model.arn);
            this.name(model.name);
            this.type(model.type);
            this.description(model.description);
            this.serviceCount(model.serviceCount);
            this.properties(model.properties);
            this.createDate(model.createDate);
            this.creatorRequestId(model.creatorRequestId);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NamespaceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getServiceCount() {
            return this.serviceCount;
        }

        @Override
        public final Builder serviceCount(Integer serviceCount) {
            this.serviceCount = serviceCount;
            return this;
        }

        public final void setServiceCount(Integer serviceCount) {
            this.serviceCount = serviceCount;
        }

        public final NamespaceProperties.Builder getProperties() {
            return this.properties != null ? this.properties.toBuilder() : null;
        }

        @Override
        public final Builder properties(NamespaceProperties properties) {
            this.properties = properties;
            return this;
        }

        public final void setProperties(NamespaceProperties.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public Namespace build() {
            return new Namespace(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Namespace> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(NamespaceType var1);

        public Builder description(String var1);

        public Builder serviceCount(Integer var1);

        public Builder properties(NamespaceProperties var1);

        default public Builder properties(Consumer<NamespaceProperties.Builder> properties) {
            return this.properties((NamespaceProperties)((NamespaceProperties.Builder)NamespaceProperties.builder().applyMutation(properties)).build());
        }

        public Builder createDate(Instant var1);

        public Builder creatorRequestId(String var1);
    }
}

