/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicediscovery.model.HttpInstanceSummary;
import software.amazon.awssdk.services.servicediscovery.model.HttpInstanceSummaryListCopier;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiscoverInstancesResponse
extends ServiceDiscoveryResponse
implements ToCopyableBuilder<Builder, DiscoverInstancesResponse> {
    private static final SdkField<List<HttpInstanceSummary>> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Instances").getter(DiscoverInstancesResponse.getter(DiscoverInstancesResponse::instances)).setter(DiscoverInstancesResponse.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HttpInstanceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> INSTANCES_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("InstancesRevision").getter(DiscoverInstancesResponse.getter(DiscoverInstancesResponse::instancesRevision)).setter(DiscoverInstancesResponse.setter(Builder::instancesRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesRevision").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCES_FIELD, INSTANCES_REVISION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DiscoverInstancesResponse.memberNameToFieldInitializer();
    private final List<HttpInstanceSummary> instances;
    private final Long instancesRevision;

    private DiscoverInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instances = builder.instances;
        this.instancesRevision = builder.instancesRevision;
    }

    public final boolean hasInstances() {
        return this.instances != null && !(this.instances instanceof SdkAutoConstructList);
    }

    public final List<HttpInstanceSummary> instances() {
        return this.instances;
    }

    public final Long instancesRevision() {
        return this.instancesRevision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstances() ? this.instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesRevision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverInstancesResponse)) {
            return false;
        }
        DiscoverInstancesResponse other = (DiscoverInstancesResponse)((Object)obj);
        return this.hasInstances() == other.hasInstances() && Objects.equals(this.instances(), other.instances()) && Objects.equals(this.instancesRevision(), other.instancesRevision());
    }

    public final String toString() {
        return ToString.builder((String)"DiscoverInstancesResponse").add("Instances", this.hasInstances() ? this.instances() : null).add("InstancesRevision", (Object)this.instancesRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
            case "InstancesRevision": {
                return Optional.ofNullable(clazz.cast(this.instancesRevision()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Instances", INSTANCES_FIELD);
        map.put("InstancesRevision", INSTANCES_REVISION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DiscoverInstancesResponse, T> g) {
        return obj -> g.apply((DiscoverInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceDiscoveryResponse.BuilderImpl
    implements Builder {
        private List<HttpInstanceSummary> instances = DefaultSdkAutoConstructList.getInstance();
        private Long instancesRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoverInstancesResponse model) {
            super(model);
            this.instances(model.instances);
            this.instancesRevision(model.instancesRevision);
        }

        public final List<HttpInstanceSummary.Builder> getInstances() {
            List<HttpInstanceSummary.Builder> result = HttpInstanceSummaryListCopier.copyToBuilder(this.instances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstances(Collection<HttpInstanceSummary.BuilderImpl> instances) {
            this.instances = HttpInstanceSummaryListCopier.copyFromBuilder(instances);
        }

        @Override
        public final Builder instances(Collection<HttpInstanceSummary> instances) {
            this.instances = HttpInstanceSummaryListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(HttpInstanceSummary ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<HttpInstanceSummary.Builder> ... instances) {
            this.instances(Stream.of(instances).map(c -> (HttpInstanceSummary)((HttpInstanceSummary.Builder)HttpInstanceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getInstancesRevision() {
            return this.instancesRevision;
        }

        public final void setInstancesRevision(Long instancesRevision) {
            this.instancesRevision = instancesRevision;
        }

        @Override
        public final Builder instancesRevision(Long instancesRevision) {
            this.instancesRevision = instancesRevision;
            return this;
        }

        @Override
        public DiscoverInstancesResponse build() {
            return new DiscoverInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ServiceDiscoveryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DiscoverInstancesResponse> {
        public Builder instances(Collection<HttpInstanceSummary> var1);

        public Builder instances(HttpInstanceSummary ... var1);

        public Builder instances(Consumer<HttpInstanceSummary.Builder> ... var1);

        public Builder instancesRevision(Long var1);
    }
}

