/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OperationTargetType {
    NAMESPACE("NAMESPACE"),
    SERVICE("SERVICE"),
    INSTANCE("INSTANCE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OperationTargetType> VALUE_MAP;
    private final String value;

    private OperationTargetType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OperationTargetType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OperationTargetType> knownValues() {
        EnumSet<OperationTargetType> knownValues = EnumSet.allOf(OperationTargetType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OperationTargetType.class, OperationTargetType::toString);
    }
}

