/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.servicediscovery.DefaultServiceDiscoveryAsyncClient;
import software.amazon.awssdk.services.servicediscovery.DefaultServiceDiscoveryBaseClientBuilder;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryAsyncClient;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryAsyncClientBuilder;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryServiceClientConfiguration;
import software.amazon.awssdk.services.servicediscovery.endpoints.ServiceDiscoveryEndpointProvider;

@SdkInternalApi
final class DefaultServiceDiscoveryAsyncClientBuilder
extends DefaultServiceDiscoveryBaseClientBuilder<ServiceDiscoveryAsyncClientBuilder, ServiceDiscoveryAsyncClient>
implements ServiceDiscoveryAsyncClientBuilder {
    DefaultServiceDiscoveryAsyncClientBuilder() {
    }

    @Override
    public DefaultServiceDiscoveryAsyncClientBuilder endpointProvider(ServiceDiscoveryEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ServiceDiscoveryAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultServiceDiscoveryAsyncClientBuilder.validateClientOptions(clientConfiguration);
        ServiceDiscoveryServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultServiceDiscoveryAsyncClient client = new DefaultServiceDiscoveryAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ServiceDiscoveryServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ServiceDiscoveryServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

