/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicediscovery.ServiceDiscoveryClient;
import software.amazon.awssdk.services.servicediscovery.model.ListNamespacesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListNamespacesResponse;

public class ListNamespacesIterable
implements SdkIterable<ListNamespacesResponse> {
    private final ServiceDiscoveryClient client;
    private final ListNamespacesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNamespacesIterable(ServiceDiscoveryClient client, ListNamespacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListNamespacesResponseFetcher();
    }

    public Iterator<ListNamespacesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListNamespacesResponseFetcher
    implements SyncPageFetcher<ListNamespacesResponse> {
        private ListNamespacesResponseFetcher() {
        }

        public boolean hasNextPage(ListNamespacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListNamespacesResponse nextPage(ListNamespacesResponse previousPage) {
            if (previousPage == null) {
                return ListNamespacesIterable.this.client.listNamespaces(ListNamespacesIterable.this.firstRequest);
            }
            return ListNamespacesIterable.this.client.listNamespaces((ListNamespacesRequest)((Object)ListNamespacesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

