/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RoutingPolicy {
    MULTIVALUE("MULTIVALUE"),
    WEIGHTED("WEIGHTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RoutingPolicy> VALUE_MAP;
    private final String value;

    private RoutingPolicy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RoutingPolicy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RoutingPolicy> knownValues() {
        EnumSet<RoutingPolicy> knownValues = EnumSet.allOf(RoutingPolicy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RoutingPolicy.class, RoutingPolicy::toString);
    }
}

